/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownField;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownMethod;
import org.eclipse.core.runtime.CoreException;

public class CPPUnknownMember
extends CPPUnknownBinding
implements ICPPUnknownMember,
ISerializableType {
    protected final IType fOwner;

    protected CPPUnknownMember(IType owner, char[] name) {
        super(name);
        if (owner instanceof ICPPClassTemplate) {
            owner = CPPTemplates.createDeferredInstance((ICPPClassTemplate)owner);
        }
        this.fOwner = owner;
    }

    @Override
    public IBinding getOwner() {
        if (this.fOwner instanceof IBinding) {
            return (IBinding)((Object)this.fOwner);
        }
        return null;
    }

    @Override
    public IType getOwnerType() {
        return this.fOwner;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 12;
        if (this instanceof ICPPField) {
            firstBytes = (short)(firstBytes | 0x20);
        } else if (this instanceof ICPPMethod) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.getOwnerType());
        buffer.putCharArray(this.getNameCharArray());
    }

    public static IBinding unmarshal(IIndexFragment fragment, short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType owner = buffer.unmarshalType();
        char[] name = buffer.getCharArray();
        if ((firstBytes & 0x20) != 0) {
            return new PDOMCPPUnknownField(fragment, owner, name);
        }
        if ((firstBytes & 0x40) != 0) {
            return new PDOMCPPUnknownMethod(fragment, owner, name);
        }
        return new PDOMCPPUnknownMemberClass(fragment, owner, name);
    }
}

