/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseEnableEventHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class EnableEventOnSessionHandler
extends BaseEnableEventHandler {
    @Override
    public void enableEvents(CommandParameter param, List<String> eventNames, TraceDomainType domain, String filterExpression, List<String> excludedEvents, IProgressMonitor monitor) throws ExecutionException {
        param.getSession().enableEvents(eventNames, domain, filterExpression, excludedEvents, monitor);
    }

    @Override
    public void enableSyscalls(CommandParameter param, List<String> syscallNames, IProgressMonitor monitor) throws ExecutionException {
        param.getSession().enableSyscalls(syscallNames, monitor);
    }

    @Override
    public void enableProbe(CommandParameter param, String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        param.getSession().enableProbe(eventName, isFunction, probe, monitor);
    }

    @Override
    public void enableLogLevel(CommandParameter param, List<String> eventNames, LogLevelType logLevelType, ITraceLogLevel level, String filterExpression, TraceDomainType domain, IProgressMonitor monitor) throws ExecutionException {
        param.getSession().enableLogLevel(eventNames, logLevelType, level, filterExpression, domain, monitor);
    }

    @Override
    public TraceDomainComponent getDomain(CommandParameter param) {
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent tmpSession;
                if (!(element instanceof TraceSessionComponent) || (tmpSession = (TraceSessionComponent)element).getSessionState() != TraceSessionState.INACTIVE || tmpSession.isDestroyed()) continue;
                session = tmpSession;
            }
        }
        boolean isEnabled = session != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new CommandParameter((TraceSessionComponent)NonNullUtils.checkNotNull(session));
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

