/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.ShowSynchronizeParticipantAction;
import org.eclipse.team.internal.ui.wizards.GlobalSynchronizeWizard;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IWorkbenchPart;

public class SynchronizePageDropDownAction
extends Action
implements IMenuCreator,
ISynchronizeParticipantListener {
    private final ISynchronizeView fView;
    private final Action synchronizeAction;
    private MenuManager menuManager;

    public SynchronizePageDropDownAction(ISynchronizeView view) {
        this.fView = view;
        Utils.initAction((IAction)this, "action.refreshSubscriber.");
        this.synchronizeAction = new Action(TeamUIMessages.GlobalRefreshAction_4){

            public void run() {
                GlobalSynchronizeWizard wizard = new GlobalSynchronizeWizard();
                WizardDialog dialog = new WizardDialog(SynchronizePageDropDownAction.this.fView.getViewSite().getShell(), (IWizard)wizard);
                dialog.open();
            }
        };
        this.synchronizeAction.setImageDescriptor(TeamImages.getImageDescriptor("eview16/synch_synch.png"));
        this.synchronizeAction.setActionDefinitionId("org.eclipse.team.ui.synchronizeAll");
        this.setMenuCreator(this);
        TeamUI.getSynchronizeManager().addSynchronizeParticipantListener(this);
        this.update();
        this.fView.getSite().getKeyBindingService().registerAction((IAction)this.synchronizeAction);
        this.setActionDefinitionId("org.eclipse.team.ui.synchronizeLast");
        this.fView.getSite().getKeyBindingService().registerAction((IAction)this);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        Menu fMenu = null;
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            fMenu = this.menuManager.createContextMenu(parent);
            ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
            this.addParticipantsToMenu(participants);
            if (participants.length > 0) {
                this.menuManager.add((IContributionItem)new Separator());
            }
            this.menuManager.add((IAction)this.synchronizeAction);
            this.menuManager.update(true);
        } else {
            fMenu = this.menuManager.getMenu();
        }
        return fMenu;
    }

    protected void addParticipantsToMenu(ISynchronizeParticipantReference[] refs) {
        ISynchronizeParticipant current = this.fView.getParticipant();
        ISynchronizeParticipantReference[] iSynchronizeParticipantReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                ISynchronizeParticipantReference page = iSynchronizeParticipantReferenceArray[n2];
                ShowSynchronizeParticipantAction action = new ShowSynchronizeParticipantAction(this.fView, page);
                try {
                    boolean isCurrent = page.getParticipant().equals(current);
                    action.setChecked(isCurrent);
                }
                catch (TeamException e) {
                    break block3;
                }
                this.menuManager.add((IAction)action);
            }
            ++n2;
        }
    }

    public void run() {
        ISynchronizeParticipant current = this.fView.getParticipant();
        if (current != null) {
            current.run((IWorkbenchPart)this.fView);
        } else {
            this.synchronizeAction.run();
        }
        this.update();
    }

    @Override
    public void participantsAdded(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(() -> {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
            this.update();
        });
    }

    @Override
    public void participantsRemoved(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(() -> {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
            this.update();
        });
    }

    public void update() {
        ISynchronizeParticipant current = this.fView.getParticipant();
        ISynchronizeParticipantReference[] refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        String text = null;
        if (current != null && refs.length > 0) {
            text = NLS.bind((String)TeamUIMessages.GlobalRefreshAction_5, (Object[])new String[]{Utils.shortenText(100, current.getName())});
            this.setToolTipText(text);
            this.setText(text);
        } else {
            text = TeamUIMessages.GlobalRefreshAction_4;
            this.setToolTipText(text);
            this.setText(text);
        }
    }
}

