/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.trace;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.lttng2.ust.core.tests.shared.LttngUstTestTraceUtils;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LttngUstTraceTest {
    private static final @NonNull CtfTestTrace TEST_TRACE = CtfTestTrace.CYG_PROFILE;
    private ITmfTrace fTrace;

    @Before
    public void setUp() {
        this.fTrace = LttngUstTestTraceUtils.getTrace(TEST_TRACE);
    }

    private static void deleteDirectory(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        dir.delete();
    }

    @After
    public void tearDown() {
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            LttngUstTestTraceUtils.dispose(TEST_TRACE);
            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
            LttngUstTraceTest.deleteDirectory(suppDir);
        }
    }

    @Test
    public void testTidAspect() throws InterruptedException {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TestEventRequest request = new TestEventRequest();
        trace.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertNull((Object)request.getErrString());
    }

    private static class TestEventRequest
    extends TmfEventRequest {
        private String errString = null;

        public TestEventRequest() {
            super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, 2, ITmfEventRequest.ExecutionType.FOREGROUND);
        }

        public void handleData(@NonNull ITmfEvent event) {
            super.handleData(event);
            Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
            if (tid == null) {
                this.errString = "No TID for event " + String.valueOf(event);
                this.cancel();
                return;
            }
            if (tid != 16073) {
                this.errString = "Wrong tid: " + String.valueOf(tid) + " for event";
                this.cancel();
                return;
            }
        }

        public String getErrString() {
            return this.errString;
        }
    }
}

