/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.properties;

import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.ui.internal.Logger;

public class StringComboBoxCellEditor
extends ComboBoxCellEditor {
    private boolean fSettingValue = false;

    public StringComboBoxCellEditor() {
    }

    public StringComboBoxCellEditor(Composite parent, String[] items) {
        super(parent, items);
    }

    public StringComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, items, style);
    }

    protected Object doGetValue() {
        Object index = super.doGetValue();
        int selection = -1;
        if (index instanceof Integer) {
            selection = (Integer)index;
        }
        if (selection >= 0) {
            return this.getItems()[selection];
        }
        if (this.getControl() instanceof CCombo) {
            return ((CCombo)this.getControl()).getText();
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if (this.fSettingValue) {
            return;
        }
        this.fSettingValue = true;
        if (value instanceof Integer) {
            super.doSetValue(value);
        } else {
            String stringValue = value.toString();
            int selection = -1;
            int i = 0;
            while (i < this.getItems().length) {
                if (this.getItems()[i].equals(stringValue)) {
                    selection = i;
                }
                ++i;
            }
            if (selection >= 0) {
                super.doSetValue((Object)new Integer(selection));
            } else {
                super.doSetValue((Object)new Integer(-1));
                if (this.getControl() instanceof CCombo && !stringValue.equals(((CCombo)this.getControl()).getText())) {
                    ((CCombo)this.getControl()).setText(stringValue);
                }
            }
        }
        this.fSettingValue = false;
    }

    public void setItems(String[] newItems) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            Logger.log((int)4, (String)"Attempted to update item list for disposed cell editor");
            return;
        }
        Object previousSelectedValue = this.getValue();
        super.setItems(newItems);
        if (previousSelectedValue != null && this.getControl() instanceof CCombo) {
            int i = 0;
            while (i < newItems.length) {
                if (newItems[i].equals(previousSelectedValue)) {
                    this.setValue(previousSelectedValue);
                }
                ++i;
            }
        }
    }
}

