/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;

public abstract class FormatTestBase {
    private final @Nullable Number fNumValue;
    private final @NonNull String fStringValue;
    private final @Nullable Number fParseValue;
    private final int fParseIndex;

    public FormatTestBase(@Nullable Number numValue, @NonNull String stringValue, @Nullable Number parseValue, int parseIndex) {
        this.fNumValue = numValue;
        this.fStringValue = stringValue;
        this.fParseValue = parseValue;
        this.fParseIndex = parseIndex;
    }

    protected abstract Format getFormatter();

    @Test
    public void testFormat() {
        if (this.fNumValue != null) {
            Assert.assertEquals((String)"format value", (Object)this.fStringValue, (Object)this.getFormatter().format(this.fNumValue));
        }
    }

    @Test
    public void testParseObject() throws ParseException {
        if (this.fParseValue != null) {
            Assert.assertEquals((String)"parseObject value", (Object)this.fParseValue, (Object)this.getFormatter().parseObject(this.fStringValue));
        } else {
            ParseException exception = null;
            try {
                this.getFormatter().parseObject(this.fStringValue);
            }
            catch (ParseException e) {
                exception = e;
            }
            Assert.assertNotNull((Object)exception);
        }
    }

    @Test
    public void testParseObject2() {
        ParsePosition pos = new ParsePosition(0);
        if (this.fParseValue != null) {
            Assert.assertEquals((String)"parseObject with pos value", (Object)this.fParseValue, (Object)this.getFormatter().parseObject(this.fStringValue, pos));
            if (this.fParseIndex < 0) {
                Assert.assertEquals((String)"String parsed final position", (long)this.fStringValue.length(), (long)pos.getIndex());
                Assert.assertEquals((String)"String parsed error index position", (long)-1L, (long)pos.getErrorIndex());
            } else {
                Assert.assertEquals((String)"String parsed final position", (long)this.fParseIndex, (long)pos.getIndex());
            }
        } else {
            Assert.assertNull((Object)this.getFormatter().parseObject(this.fStringValue, pos));
            Assert.assertNotEquals((String)"String parsed final position", (long)this.fStringValue.length(), (long)pos.getIndex());
        }
    }

    @Test
    public void testFormatIllegalArgument() {
        Assert.assertEquals((String)"Illegal argument", (Object)"", (Object)this.getFormatter().format("Toto"));
    }
}

