/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.common.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.tracecompass.common.core.TraceCompassActivator;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class Activator
extends TraceCompassActivator {
    private static final String PLUGIN_ID = "org.eclipse.tracecompass.common.core";

    public static Activator instance() {
        return (Activator)TraceCompassActivator.getInstance(PLUGIN_ID);
    }

    public Activator() {
        super(PLUGIN_ID);
    }

    @Override
    protected void startActions() {
        Logger logger = TraceCompassLog.getLogger(((Object)((Object)this)).getClass());
        int nbCpus = Runtime.getRuntime().availableProcessors();
        long memory = Runtime.getRuntime().totalMemory();
        String os = System.getProperty("os.name");
        String hostName = "Unknown";
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            hostName = localMachine.getHostName();
        }
        catch (UnknownHostException localMachine) {
            // empty catch block
        }
        double data = 9.9999993E7;
        double otherData = 123.321;
        long start = System.nanoTime();
        int i = 0;
        while (i < 1000000) {
            data /= otherData;
            if ((data *= otherData) < 0.0) {
                throw new IllegalStateException("Floating point error on CPU!");
            }
            ++i;
        }
        long end = System.nanoTime();
        long bogoMips = (long)(1.0E12 / (double)(end - start));
        LogUtils.traceInstant((Logger)logger, (Level)Level.SEVERE, (String)PLUGIN_ID, (Object[])new Object[]{"HostName", hostName, "OS", os, "Nb Processors", nbCpus, "BogoMips", bogoMips, "Memory", memory});
    }

    @Override
    protected void stopActions() {
    }
}

