/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.graph;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class LttngExecutionGraphTest {
    private static final @NonNull String TEST_ANALYSIS_ID = "org.eclipse.tracecompass.analysis.os.linux.execgraph";

    public ITmfTrace setUpTrace(String traceFile) {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(traceFile);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = null;
        Iterator iterator = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, AbstractTmfGraphBuilderModule.class).iterator();
        while (iterator.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)iterator.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        module.waitForCompletion();
        return trace;
    }

    @Test
    public void testSchedEvents() {
        ITmfTrace trace = this.setUpTrace("testfiles/graph/sched_only.xml");
        Assert.assertNotNull((Object)trace);
        AbstractTmfGraphBuilderModule module = (AbstractTmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, AbstractTmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        ITmfGraph graph = module.getTmfGraph();
        Assert.assertNotNull((Object)graph);
        Collection workers = graph.getWorkers();
        Assert.assertEquals((long)2L, (long)workers.size());
        for (IGraphWorker worker : workers) {
            Assert.assertTrue((boolean)(worker instanceof OsWorker));
            OsWorker lttngWorker = (OsWorker)worker;
            switch (lttngWorker.getHostThread().getTid()) {
                case 1: {
                    ImmutableList nodesOf = ImmutableList.copyOf((Iterator)graph.getNodesOf((IGraphWorker)lttngWorker));
                    Assert.assertEquals((long)4L, (long)nodesOf.size());
                    ITmfVertex v = (ITmfVertex)nodesOf.get(0);
                    Assert.assertEquals((long)10L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    ITmfEdge edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.PREEMPTED, (Object)edge.getEdgeContextState().getContextEnum());
                    v = (ITmfVertex)nodesOf.get(1);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)20L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.RUNNING, (Object)edge.getEdgeContextState().getContextEnum());
                    v = (ITmfVertex)nodesOf.get(2);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)30L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.PREEMPTED, (Object)edge.getEdgeContextState().getContextEnum());
                    v = (ITmfVertex)nodesOf.get(3);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)40L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
                    break;
                }
                case 2: {
                    ImmutableList nodesOf = ImmutableList.copyOf((Iterator)graph.getNodesOf((IGraphWorker)lttngWorker));
                    Assert.assertEquals((long)4L, (long)nodesOf.size());
                    ITmfVertex v = (ITmfVertex)nodesOf.get(0);
                    Assert.assertEquals((long)10L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    ITmfEdge edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.RUNNING, (Object)edge.getEdgeContextState().getContextEnum());
                    v = (ITmfVertex)nodesOf.get(1);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)20L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.BLOCKED, (Object)edge.getEdgeContextState().getContextEnum());
                    v = (ITmfVertex)nodesOf.get(2);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)30L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                    Assert.assertNotNull((Object)edge);
                    Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.RUNNING, (Object)edge.getEdgeContextState().getContextEnum());
                    v = (ITmfVertex)nodesOf.get(3);
                    Assert.assertEquals((Object)v, (Object)edge.getVertexTo());
                    Assert.assertEquals((long)40L, (long)v.getTimestamp());
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
                    Assert.assertNotNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
                    Assert.assertNull((Object)graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown worker");
                }
            }
        }
        trace.dispose();
    }
}

