/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.event.matchandsync;

import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class ExperimentSyncTest {
    @Rule
    public TestRule timeoutRule = new Timeout(2L, TimeUnit.MINUTES);
    private static final String EXPERIMENT = "MyExperiment";
    private static int BLOCK_SIZE = 1000;

    @BeforeClass
    public static void setUp() {
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
    }

    @Test
    public void testExperimentSync() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_SRC);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_DEST);
        ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2};
        TmfExperiment experiment = new TmfExperiment(traces[0].getEventType(), EXPERIMENT, traces, BLOCK_SIZE, null);
        SynchronizationAlgorithm syncAlgo = experiment.synchronizeTraces(true);
        ITmfTimestampTransform tt1 = syncAlgo.getTimestampTransform((ITmfTrace)trace1);
        ITmfTimestampTransform tt2 = syncAlgo.getTimestampTransform((ITmfTrace)trace2);
        trace1.setTimestampTransform(tt1);
        trace2.setTimestampTransform(tt2);
        Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 0.9999413783703139011056845831168394, offset = 79796507913179.33347660124688298171 ]", (Object)tt1.toString());
        Assert.assertEquals((Object)TimestampTransformFactory.getDefaultTransform(), (Object)tt2);
        Assert.assertEquals((Object)syncAlgo.getTimestampTransform(trace1.getHostId()), (Object)trace1.getTimestampTransform());
        Assert.assertEquals((Object)syncAlgo.getTimestampTransform(trace2.getHostId()), (Object)trace2.getTimestampTransform());
        experiment.dispose();
    }

    @Test
    public void testDjangoExperimentSync() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_CLIENT);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_DB);
        CtfTmfTrace trace3 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_HTTPD);
        ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2, trace3};
        TmfExperiment experiment = new TmfExperiment(traces[0].getEventType(), EXPERIMENT, traces, BLOCK_SIZE, null);
        SynchronizationAlgorithm syncAlgo = experiment.synchronizeTraces(true);
        ITmfTimestampTransform tt1 = syncAlgo.getTimestampTransform((ITmfTrace)trace1);
        ITmfTimestampTransform tt2 = syncAlgo.getTimestampTransform((ITmfTrace)trace2);
        ITmfTimestampTransform tt3 = syncAlgo.getTimestampTransform((ITmfTrace)trace3);
        trace1.setTimestampTransform(tt1);
        trace2.setTimestampTransform(tt2);
        trace3.setTimestampTransform(tt3);
        Assert.assertEquals((Object)TimestampTransformFactory.getDefaultTransform(), (Object)tt1);
        Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 0.9999996313017589597204633828681240, offset = 498490309972.0038068817738527724192 ]", (Object)tt2.toString());
        Assert.assertEquals((Object)"TmfTimestampTransformLinearFast [ slope = 1.000000119014882262265342419815932, offset = -166652893534.6189900382736187431134 ]", (Object)tt3.toString());
        experiment.dispose();
    }
}

