/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.AgentLocation;
import org.eclipse.equinox.internal.p2.core.DefaultAgentProvider;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    public static IAgentLocation agentDataLocation = null;
    private static BundleContext context;
    private static final String DEFAULT_AGENT_LOCATION = "../p2";
    public static final String ID = "org.eclipse.equinox.p2.core";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String NONE = "@none";
    private static final String PROP_AGENT_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_CONFIG_DIR = "osgi.configuration.area";
    private static final String PROP_SHARED_CONFIG_DIR = "osgi.sharedConfiguration.area";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_USER_HOME = "user.home";
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    private static final String VAR_CONFIG_DIR = "@config.dir";
    private static final String VAR_USER_DIR = "@user.dir";
    private static final String VAR_USER_HOME = "@user.home";
    private IProvisioningAgent agent;
    private ServiceRegistration<IAgentLocation> agentLocationRegistration = null;

    private static URI adjustTrailingSlash(URI url, boolean trailingSlash) throws URISyntaxException {
        Object file = url.toString();
        if (trailingSlash == ((String)file).endsWith("/")) {
            return url;
        }
        file = trailingSlash ? (String)file + "/" : ((String)file).substring(0, ((String)file).length() - 1);
        return new URI((String)file);
    }

    private static URI buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return Activator.adjustTrailingSlash(new File(spec.substring(5)).toURI(), trailingSlash);
            }
            new URL(spec);
            return new URI(spec);
        }
        catch (Exception e) {
            if (isFile) {
                return null;
            }
            try {
                return Activator.adjustTrailingSlash(new File(spec).toURI(), trailingSlash);
            }
            catch (URISyntaxException e1) {
                return null;
            }
        }
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = Activator.getProperty(prop);
        if (value == null) {
            value = "";
        }
        return value + source.substring(var.length());
    }

    public static String getProperty(String prop) {
        BundleContext bundleContext = context;
        if (bundleContext != null) {
            return bundleContext.getProperty(prop);
        }
        return System.getProperty(prop);
    }

    private IAgentLocation buildLocation(String property, URI defaultLocation, boolean readOnlyDefault, boolean addTrailingSlash) {
        String location = Activator.getProperty(property);
        if (location == null) {
            return new AgentLocation(defaultLocation);
        }
        if (location.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (location.equalsIgnoreCase(NO_DEFAULT)) {
            return new AgentLocation(null);
        }
        if (location.startsWith(VAR_USER_HOME)) {
            base = Activator.substituteVar(location, VAR_USER_HOME, PROP_USER_HOME);
            location = IPath.fromOSString((String)base).toFile().getAbsolutePath();
        } else if (location.startsWith(VAR_USER_DIR)) {
            base = Activator.substituteVar(location, VAR_USER_DIR, PROP_USER_DIR);
            location = IPath.fromOSString((String)base).toFile().getAbsolutePath();
        } else if (location.startsWith(VAR_CONFIG_DIR)) {
            location = Activator.substituteVar(location, VAR_CONFIG_DIR, PROP_CONFIG_DIR);
        }
        URI url = Activator.buildURL(location, addTrailingSlash);
        AgentLocation result = null;
        if (url != null) {
            result = new AgentLocation(url);
        }
        return result;
    }

    private void registerAgent() {
        if (agentDataLocation == null) {
            return;
        }
        ServiceReference agentProviderRef = context.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider provider = null;
        if (agentProviderRef != null) {
            provider = (IProvisioningAgentProvider)context.getService(agentProviderRef);
        }
        if (provider == null) {
            provider = new DefaultAgentProvider();
            ((DefaultAgentProvider)provider).activate(context);
        }
        try {
            this.agent = provider.createAgent(null);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate p2 agent at location " + String.valueOf(agentDataLocation.getRootLocation());
            LogHelper.log((IStatus)new Status(4, ID, msg, (Throwable)e));
        }
        this.registerSharedAgent(this.agent, provider);
    }

    private URI computeLocationSharedAgent(IProvisioningAgent currentAgent, IProvisioningAgentProvider provider) {
        Object sharedConfigArea;
        URI location;
        block4: {
            location = null;
            sharedConfigArea = null;
            try {
                sharedConfigArea = context.getProperty(PROP_SHARED_CONFIG_DIR);
                if (sharedConfigArea != null) break block4;
                return null;
            }
            catch (URISyntaxException e) {
                String msg = "Unable to instantiate p2 agent for shared location " + (String)sharedConfigArea;
                LogHelper.log((IStatus)new Status(2, ID, msg, (Throwable)e));
                return null;
            }
        }
        if (!((String)sharedConfigArea).endsWith("/") && !((String)sharedConfigArea).endsWith("\\")) {
            sharedConfigArea = (String)sharedConfigArea + "/";
        }
        location = URIUtil.fromString((String)((String)sharedConfigArea + "../p2/"));
        return location;
    }

    private void registerSharedAgent(IProvisioningAgent currentAgent, IProvisioningAgentProvider provider) {
        URI location = this.computeLocationSharedAgent(currentAgent, provider);
        if (location == null) {
            return;
        }
        try {
            IProvisioningAgent sharedAgent = provider.createAgent(location);
            currentAgent.registerService("org.eclipse.equinox.shared.base.agent", sharedAgent);
            sharedAgent.registerService("org.eclipse.equinox.shared.current.agent", currentAgent);
        }
        catch (ProvisionException e) {
            String msg = "Unable to instantiate p2 agent for shared location " + String.valueOf(location);
            LogHelper.log((IStatus)new Status(2, ID, msg, (Throwable)((Object)e)));
        }
    }

    public void start(BundleContext aContext) throws Exception {
        context = aContext;
        URI defaultLocation = URIUtil.fromString((String)(aContext.getProperty(PROP_CONFIG_DIR) + "../p2/"));
        agentDataLocation = this.buildLocation(PROP_AGENT_DATA_AREA, defaultLocation, false, true);
        Hashtable<String, String> locationProperties = new Hashtable<String, String>();
        if (agentDataLocation != null) {
            ((Dictionary)locationProperties).put("type", PROP_AGENT_DATA_AREA);
            this.agentLocationRegistration = aContext.registerService(IAgentLocation.class, (Object)agentDataLocation, locationProperties);
        }
        this.registerAgent();
    }

    public void stop(BundleContext aContext) throws Exception {
        this.unregisterAgent();
        agentDataLocation = null;
        if (this.agentLocationRegistration != null) {
            this.agentLocationRegistration.unregister();
        }
        context = null;
    }

    private void unregisterAgent() {
        if (this.agent != null) {
            this.agent.stop();
            this.agent = null;
        }
    }
}

