/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.math;

import org.eclipse.tracecompass.common.core.math.SaturatedArithmetic;
import org.junit.Assert;
import org.junit.Test;

public class SaturatedArithmeticTest {
    @Test
    public void testMult0() {
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)0));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)1));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)1, (int)0));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)42, (int)0));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)42));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)-42, (int)0));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)-42));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)Integer.MAX_VALUE, (int)0));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)Integer.MIN_VALUE, (int)0));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testMult1() {
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((int)0, (int)1));
        Assert.assertEquals((long)1L, (long)SaturatedArithmetic.multiply((int)1, (int)1));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.multiply((int)42, (int)1));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.multiply((int)1, (int)42));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.multiply((int)-42, (int)1));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.multiply((int)1, (int)-42));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MAX_VALUE, (int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)1, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MIN_VALUE, (int)1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)1, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testMult100() {
        Assert.assertEquals((long)10000L, (long)SaturatedArithmetic.multiply((int)100, (int)100));
        Assert.assertEquals((long)-10000L, (long)SaturatedArithmetic.multiply((int)100, (int)-100));
        Assert.assertEquals((long)-10000L, (long)SaturatedArithmetic.multiply((int)-100, (int)100));
        Assert.assertEquals((long)10000L, (long)SaturatedArithmetic.multiply((int)-100, (int)-100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MAX_VALUE, (int)100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)100, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MIN_VALUE, (int)100));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)100, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MAX_VALUE, (int)-100));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)-100, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MIN_VALUE, (int)-100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)-100, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testMultLimit() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.multiply((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testMult0L() {
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)0L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)1L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)1L, (long)0L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)42L, (long)0L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)42L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)-42L, (long)0L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)-42L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)Long.MAX_VALUE, (long)0L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)Long.MIN_VALUE, (long)0L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)Long.MIN_VALUE));
    }

    @Test
    public void testMult1L() {
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.multiply((long)0L, (long)1L));
        Assert.assertEquals((long)1L, (long)SaturatedArithmetic.multiply((long)1L, (long)1L));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.multiply((long)42L, (long)1L));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.multiply((long)1L, (long)42L));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.multiply((long)-42L, (long)1L));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.multiply((long)1L, (long)-42L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MAX_VALUE, (long)1L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)1L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MIN_VALUE, (long)1L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)1L, (long)Long.MIN_VALUE));
    }

    @Test
    public void testMult100L() {
        Assert.assertEquals((long)10000L, (long)SaturatedArithmetic.multiply((long)100L, (long)100L));
        Assert.assertEquals((long)-10000L, (long)SaturatedArithmetic.multiply((long)100L, (long)-100L));
        Assert.assertEquals((long)-10000L, (long)SaturatedArithmetic.multiply((long)-100L, (long)100L));
        Assert.assertEquals((long)10000L, (long)SaturatedArithmetic.multiply((long)-100L, (long)-100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MAX_VALUE, (long)100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)100L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MIN_VALUE, (long)100L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)100L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MAX_VALUE, (long)-100L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)-100L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MIN_VALUE, (long)-100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)-100L, (long)Long.MIN_VALUE));
    }

    @Test
    public void testMultLimitL() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MAX_VALUE, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MAX_VALUE, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MIN_VALUE, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.multiply((long)Long.MIN_VALUE, (long)Long.MIN_VALUE));
    }

    @Test
    public void testAdd0() {
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.add((int)0, (int)0));
        Assert.assertEquals((long)1L, (long)SaturatedArithmetic.add((int)0, (int)1));
        Assert.assertEquals((long)1L, (long)SaturatedArithmetic.add((int)1, (int)0));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.add((int)42, (int)0));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.add((int)0, (int)42));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.add((int)-42, (int)0));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.add((int)0, (int)-42));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.add((int)Integer.MAX_VALUE, (int)0));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.add((int)0, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.add((int)Integer.MIN_VALUE, (int)0));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.add((int)0, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testAdd100() {
        Assert.assertEquals((long)200L, (long)SaturatedArithmetic.add((int)100, (int)100));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.add((int)100, (int)-100));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.add((int)-100, (int)100));
        Assert.assertEquals((long)-200L, (long)SaturatedArithmetic.add((int)-100, (int)-100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.add((int)Integer.MAX_VALUE, (int)100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.add((int)100, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-2147483548L, (long)SaturatedArithmetic.add((int)Integer.MIN_VALUE, (int)100));
        Assert.assertEquals((long)-2147483548L, (long)SaturatedArithmetic.add((int)100, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)2147483547L, (long)SaturatedArithmetic.add((int)Integer.MAX_VALUE, (int)-100));
        Assert.assertEquals((long)2147483547L, (long)SaturatedArithmetic.add((int)-100, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.add((int)Integer.MIN_VALUE, (int)-100));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.add((int)-100, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testAddLimit() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)SaturatedArithmetic.add((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)SaturatedArithmetic.add((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)SaturatedArithmetic.add((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)SaturatedArithmetic.add((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testAdd0L() {
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.add((long)0L, (long)0L));
        Assert.assertEquals((long)1L, (long)SaturatedArithmetic.add((long)0L, (long)1L));
        Assert.assertEquals((long)1L, (long)SaturatedArithmetic.add((long)1L, (long)0L));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.add((long)42L, (long)0L));
        Assert.assertEquals((long)42L, (long)SaturatedArithmetic.add((long)0L, (long)42L));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.add((long)-42L, (long)0L));
        Assert.assertEquals((long)-42L, (long)SaturatedArithmetic.add((long)0L, (long)-42L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.add((long)Long.MAX_VALUE, (long)0L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.add((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.add((long)Long.MIN_VALUE, (long)0L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.add((long)0L, (long)Long.MIN_VALUE));
    }

    @Test
    public void testAdd100L() {
        Assert.assertEquals((long)200L, (long)SaturatedArithmetic.add((long)100L, (long)100L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.add((long)100L, (long)-100L));
        Assert.assertEquals((long)0L, (long)SaturatedArithmetic.add((long)-100L, (long)100L));
        Assert.assertEquals((long)-200L, (long)SaturatedArithmetic.add((long)-100L, (long)-100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.add((long)Long.MAX_VALUE, (long)100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.add((long)100L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)-9223372036854775708L, (long)SaturatedArithmetic.add((long)Long.MIN_VALUE, (long)100L));
        Assert.assertEquals((long)-9223372036854775708L, (long)SaturatedArithmetic.add((long)100L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)9223372036854775707L, (long)SaturatedArithmetic.add((long)Long.MAX_VALUE, (long)-100L));
        Assert.assertEquals((long)9223372036854775707L, (long)SaturatedArithmetic.add((long)-100L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.add((long)Long.MIN_VALUE, (long)-100L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.add((long)-100L, (long)Long.MIN_VALUE));
    }

    @Test
    public void testAddLimitL() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)SaturatedArithmetic.add((long)Long.MAX_VALUE, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)SaturatedArithmetic.add((long)Long.MAX_VALUE, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)SaturatedArithmetic.add((long)Long.MIN_VALUE, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)SaturatedArithmetic.add((long)Long.MIN_VALUE, (long)Long.MIN_VALUE));
    }

    @Test
    public void testSameSign() {
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)0L, (long)0L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)0L, (long)0L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)0L, (long)-100L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)-100L, (long)0L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)0L, (long)100L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)100L, (long)0L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)0L, (long)-100L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)-100L, (long)0L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)0L, (long)100L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)100L, (long)0L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)100L, (long)100L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)100L, (long)-100L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)-100L, (long)100L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)-100L, (long)-100L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)Long.MAX_VALUE, (long)100L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)100L, (long)Long.MAX_VALUE));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)Long.MIN_VALUE, (long)100L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)100L, (long)Long.MIN_VALUE));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)Long.MAX_VALUE, (long)-100L));
        Assert.assertFalse((boolean)SaturatedArithmetic.sameSign((long)-100L, (long)Long.MAX_VALUE));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)Long.MIN_VALUE, (long)-100L));
        Assert.assertTrue((boolean)SaturatedArithmetic.sameSign((long)-100L, (long)Long.MIN_VALUE));
    }
}

