/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event.lookup;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.junit.Assert;
import org.junit.Test;

public class TmfCallsiteTest {
    private static final @NonNull String fFileName1 = "filename1";
    private static final Long fLine1 = 10L;
    private static final @NonNull String fFileName2 = "filename2";
    private static final Long fLine2 = 25L;
    private static final @NonNull String fFileName3 = "filename3";
    private static final Long fLine3 = 123L;
    private static final @NonNull String fFileName4 = "filename1";
    private static final Long fLine4 = 11L;
    private static final @NonNull ITmfCallsite fCallsite1 = new TmfCallsite("filename1", fLine1);
    private static final @NonNull ITmfCallsite fCallsite2 = new TmfCallsite("filename2", fLine2);
    private static final @NonNull ITmfCallsite fCallsite3 = new TmfCallsite("filename3", fLine3);
    private static final @NonNull ITmfCallsite fCallsite4 = new TmfCallsite("filename1", fLine4);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((Object)"filename1", (Object)fCallsite1.getFileName());
        Assert.assertEquals((Object)fLine1, (Object)fCallsite1.getLineNo());
    }

    @Test
    public void testCallsiteCopy() {
        TmfCallsite copy = new TmfCallsite(fCallsite1);
        Assert.assertEquals((Object)"filename1", (Object)copy.getFileName());
        Assert.assertEquals((Object)fLine1, (Object)copy.getLineNo());
    }

    @Test
    public void testHashCode() {
        TmfCallsite callsite1b = new TmfCallsite(fCallsite1);
        TmfCallsite callsite2b = new TmfCallsite(fCallsite2);
        TmfCallsite callsite3b = new TmfCallsite(fCallsite3);
        Assert.assertEquals((String)"hashCode", (long)fCallsite1.hashCode(), (long)callsite1b.hashCode());
        Assert.assertEquals((String)"hashCode", (long)fCallsite2.hashCode(), (long)callsite2b.hashCode());
        Assert.assertEquals((String)"hashCode", (long)fCallsite3.hashCode(), (long)callsite3b.hashCode());
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)fCallsite1.equals(fCallsite1));
        Assert.assertTrue((String)"equals", (boolean)fCallsite2.equals(fCallsite2));
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(fCallsite2));
        Assert.assertFalse((String)"equals", (boolean)fCallsite2.equals(fCallsite1));
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(fCallsite4));
        Assert.assertFalse((String)"equals", (boolean)fCallsite4.equals(fCallsite1));
    }

    @Test
    public void testEqualsSymmetry() {
        TmfCallsite callsite1 = new TmfCallsite(fCallsite1);
        TmfCallsite callsite2 = new TmfCallsite(fCallsite2);
        Assert.assertTrue((String)"equals", (boolean)callsite1.equals(fCallsite1));
        Assert.assertTrue((String)"equals", (boolean)fCallsite1.equals(callsite1));
        Assert.assertTrue((String)"equals", (boolean)callsite2.equals(fCallsite2));
        Assert.assertTrue((String)"equals", (boolean)fCallsite2.equals(callsite2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfCallsite callsite1 = new TmfCallsite(fCallsite1);
        TmfCallsite callsite2 = new TmfCallsite(fCallsite1);
        TmfCallsite callsite3 = new TmfCallsite(fCallsite1);
        Assert.assertTrue((String)"equals", (boolean)callsite1.equals(callsite2));
        Assert.assertTrue((String)"equals", (boolean)callsite2.equals(callsite3));
        Assert.assertTrue((String)"equals", (boolean)callsite1.equals(callsite3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)fCallsite2.equals(null));
        Assert.assertFalse((String)"equals", (boolean)fCallsite3.equals(null));
    }

    @Test
    public void testNonEqualClasses() {
        Assert.assertFalse((String)"equals", (boolean)fCallsite1.equals(fCallsite1.getFileName()));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)"toString", (Object)"filename1:10", (Object)fCallsite1.toString());
        Assert.assertEquals((String)"toString", (Object)"filename2:25", (Object)fCallsite2.toString());
        Assert.assertEquals((String)"toString", (Object)"filename3:123", (Object)fCallsite3.toString());
    }
}

