/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.IPreCheckStateListener;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class TriStateFilteredCheckboxTree
extends FilteredCheckboxTree {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TriStateFilteredCheckboxTree.class);
    private Set<Object> fGrayedObjects = new HashSet<Object>();
    private List<IPreCheckStateListener> fPreCheckStateListeners = new ArrayList<IPreCheckStateListener>();

    @Deprecated
    public TriStateFilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        this(parent, treeStyle, filter, useNewLook, false);
    }

    public TriStateFilteredCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook, boolean useFastHashLookup) {
        super(parent, treeStyle, filter, useNewLook, useFastHashLookup);
    }

    @Override
    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#setCheckedElements", new Object[0]);){
            this.maintainAllCheckIntegrity();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean setSubtreeChecked(Object element, boolean state) {
        HashSet<Object> prevChecked = new HashSet<Object>(Arrays.asList(this.getCheckedElements()));
        if (state) {
            prevChecked.remove(element);
        } else {
            prevChecked.add(element);
        }
        for (IPreCheckStateListener preCheckStateListener : this.fPreCheckStateListeners) {
            if (preCheckStateListener == null || !preCheckStateListener.setSubtreeChecked(element, state)) continue;
            this.setCheckedElements(prevChecked.toArray());
            return false;
        }
        this.checkSubtree(element, state);
        this.maintainCheckIntegrity(((ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(element));
        return this.getCheckboxTreeViewer().setSubtreeChecked(element, state);
    }

    @Override
    protected TreeViewer doCreateTreeViewer(Composite parentComposite, int style) {
        TreeViewer tree = super.doCreateTreeViewer(parentComposite, style);
        if (tree instanceof CheckboxTreeViewer) {
            CheckboxTreeViewer checkboxTree = (CheckboxTreeViewer)tree;
            checkboxTree.addCheckStateListener(event -> {
                boolean bl = this.setSubtreeChecked(event.getElement(), event.getChecked());
            });
        }
        return tree;
    }

    @Override
    protected WorkbenchJob doCreateRefreshJob() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog fsl = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#doCreateRefreshJob", new Object[0]).setCategory("refreshJob").build();){
            WorkbenchJob job = super.doCreateRefreshJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (TraceCompassLogUtils.FlowScopeLog fsl1 = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#doCreateRefreshJob", new Object[0]).setParentScope(fsl).build();){
                        if (TriStateFilteredCheckboxTree.this.getCheckboxTreeViewer().getTree().isDisposed()) {
                            return;
                        }
                        TriStateFilteredCheckboxTree.this.maintainAllCheckIntegrity();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            });
            return job;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void checkSubtree(Object element, boolean state) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.ScopeLog checkST = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#checkSubtree()", new Object[0]);){
            CheckboxTreeViewer checkboxTreeViewer = this.getCheckboxTreeViewer();
            if (checkboxTreeViewer.testFindItem(element) != null) {
                if (state) {
                    this.fCheckedObjects.add(element);
                } else {
                    this.fCheckedObjects.remove(element);
                }
            }
            boolean expanded = checkboxTreeViewer.getExpandedState(element);
            checkboxTreeViewer.setExpandedState(element, true);
            Object[] objectArray = ((ITreeContentProvider)checkboxTreeViewer.getContentProvider()).getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.checkSubtree(o, state);
                ++n2;
            }
            checkboxTreeViewer.setExpandedState(element, expanded);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean getGrayed(Object element) {
        return this.fGrayedObjects.contains(element);
    }

    private boolean setGrayed(Object element, boolean state) {
        boolean checkable = this.getCheckboxTreeViewer().setGrayed(element, state);
        if (!state) {
            this.fGrayedObjects.remove(element);
        } else if (checkable) {
            this.fGrayedObjects.add(element);
        }
        return checkable;
    }

    private void maintainCheckIntegrity(Object element) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog maintain = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#maintainChackIntegrity", new Object[0]);){
            if (element == null) {
                return;
            }
            CheckboxTreeViewer checkboxTreeViewer = this.getCheckboxTreeViewer();
            ITreeContentProvider contentProvider = (ITreeContentProvider)checkboxTreeViewer.getContentProvider();
            boolean allChecked = true;
            boolean oneChecked = false;
            boolean oneGrayed = false;
            Throwable throwable2 = null;
            Object var11_15 = null;
            try (TraceCompassLogUtils.ScopeLog scanChildren = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#scanChildren", new Object[0]);){
                Object[] objectArray = contentProvider.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block44: {
                        Object child;
                        block43: {
                            child = objectArray[n2];
                            if (!this.filterText.getText().isEmpty()) {
                                Throwable throwable3 = null;
                                Object var18_26 = null;
                                try (TraceCompassLogUtils.ScopeLog testFind = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#testFind", new Object[0]);){
                                    if (checkboxTreeViewer.testFindItem(child) != null) break block43;
                                    break block44;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                        boolean checked = this.getChecked(child);
                        oneChecked |= checked;
                        allChecked &= checked;
                        oneGrayed |= checked && this.getGrayed(child);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            throwable2 = null;
            var11_15 = null;
            try (TraceCompassLogUtils.ScopeLog updateParent = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#updateParent", new Object[0]);){
                if (oneGrayed || oneChecked && !allChecked) {
                    this.setGrayed(element, true);
                    this.setChecked(element, true);
                } else {
                    this.setGrayed(element, false);
                    this.setChecked(element, allChecked);
                }
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
            Object parentElement = contentProvider.getParent(element);
            if (parentElement != null) {
                this.maintainCheckIntegrity(parentElement);
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    private void maintainAllCheckIntegrity() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "#maintainAllCheckIntegrity", new Object[0]);){
            Object[] objectArray = this.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                this.maintainCheckIntegrity(checkedElement);
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setFilterText(String string) {
        super.setFilterText(string);
    }

    public void addPreCheckStateListener(IPreCheckStateListener listener) {
        this.fPreCheckStateListeners.add(listener);
    }
}

