/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTSwitchStatement
extends ASTAttributeOwner
implements IASTSwitchStatement,
IASTAmbiguityParent {
    private IASTExpression controller;
    private IASTStatement body;

    public CASTSwitchStatement() {
    }

    public CASTSwitchStatement(IASTExpression controller, IASTStatement body) {
        this.setControllerExpression(controller);
        this.setBody(body);
    }

    @Override
    public CASTSwitchStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTSwitchStatement copy(IASTNode.CopyStyle style) {
        CASTSwitchStatement copy = new CASTSwitchStatement();
        copy.setControllerExpression(this.controller == null ? null : this.controller.copy(style));
        copy.setBody(this.body == null ? null : this.body.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getControllerExpression() {
        return this.controller;
    }

    @Override
    public void setControllerExpression(IASTExpression controller) {
        this.assertNotFrozen();
        this.controller = controller;
        if (controller != null) {
            controller.setParent(this);
            controller.setPropertyInParent(CONTROLLER_EXP);
        }
    }

    @Override
    public IASTStatement getBody() {
        return this.body;
    }

    @Override
    public void setBody(IASTStatement body) {
        this.assertNotFrozen();
        this.body = body;
        if (body != null) {
            body.setParent(this);
            body.setPropertyInParent(BODY);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.controller != null && !this.controller.accept(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.body = (IASTStatement)other;
        }
        if (child == this.controller) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.controller = (IASTExpression)other;
        }
    }
}

