/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.mapping.DiffTreeStatusLineContributionGroup;
import org.eclipse.team.internal.ui.synchronize.AbstractViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.actions.ActionContext;

public abstract class StructuredViewerAdvisor
extends AbstractViewerAdvisor {
    private IPropertyChangeListener propertyListener = event -> {
        StructuredViewer viewer;
        if (event.getProperty().equals("org.eclipse.team.ui.view_syncinfo_in_label") && (viewer = this.getViewer()) != null && !viewer.getControl().isDisposed()) {
            viewer.refresh(true);
        }
    };
    private DiffTreeStatusLineContributionGroup statusLine;

    public StructuredViewerAdvisor(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void initializeViewer(StructuredViewer viewer) {
        super.initializeViewer(viewer);
        this.initializeListeners(viewer);
        this.hookContextMenu(viewer);
    }

    public void dispose() {
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        if (this.statusLine != null) {
            this.statusLine.dispose();
        }
        TeamUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(this.propertyListener);
    }

    protected void initializeListeners(StructuredViewer viewer) {
        viewer.getControl().addDisposeListener(e -> this.dispose());
        new OpenAndLinkWithEditorHelper(viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    StructuredViewerAdvisor.this.handleOpen();
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                StructuredViewerAdvisor.this.handleOpen();
            }
        };
        viewer.addDoubleClickListener(event -> {
            boolean bl = this.handleDoubleClick(viewer, event);
        });
        viewer.addSelectionChangedListener(event -> this.updateActionBars(viewer.getStructuredSelection()));
        TeamUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(this.propertyListener);
    }

    protected boolean handleDoubleClick(StructuredViewer viewer, DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object node = selection.getFirstElement();
        if (node != null && node instanceof SyncInfoModelElement) {
            SyncInfoModelElement syncNode = (SyncInfoModelElement)node;
            IResource resource = syncNode.getResource();
            if (syncNode != null && resource != null && resource.getType() == 1) {
                return true;
            }
        }
        return false;
    }

    private void handleOpen() {
        Object o = this.getConfiguration().getProperty("org.eclipse.team.ui.P_OPEN_ACTION");
        if (o instanceof IAction) {
            IAction action = (IAction)o;
            action.run();
        }
    }

    @Override
    public final void setActionBars(IActionBars actionBars) {
        if (actionBars != null) {
            String[] groups;
            IToolBarManager manager = actionBars.getToolBarManager();
            Object o = this.getConfiguration().getProperty("org.eclipse.team.ui.P_TOOLBAR_MENU");
            if (!(o instanceof String[])) {
                o = ISynchronizePageConfiguration.DEFAULT_TOOLBAR_MENU;
            }
            String[] stringArray = groups = o;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                manager.add((IContributionItem)new Separator(this.getGroupId(group)));
                ++n2;
            }
            IMenuManager menu = actionBars.getMenuManager();
            if (menu != null) {
                o = this.getConfiguration().getProperty("org.eclipse.team.ui.P_VIEW_MENU");
                if (!(o instanceof String[])) {
                    o = ISynchronizePageConfiguration.DEFAULT_VIEW_MENU;
                }
                groups = o;
                this.initializeStatusLine(actionBars);
                String[] stringArray2 = groups;
                int n3 = groups.length;
                n = 0;
                while (n < n3) {
                    String group = stringArray2[n];
                    menu.add((IContributionItem)new Separator(this.getGroupId(group)));
                    ++n;
                }
            }
            this.fillActionBars(actionBars);
        }
    }

    protected void initializeStatusLine(IActionBars actionBars) {
        this.statusLine = new DiffTreeStatusLineContributionGroup(this.getConfiguration().getSite().getShell(), this.getConfiguration());
        IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
        if (statusLineMgr != null && this.statusLine != null) {
            this.statusLine.fillActionBars(actionBars);
        }
    }

    private void hookContextMenu(final StructuredViewer viewer) {
        String targetID = this.getContextMenuId(viewer);
        final MenuManager menuMgr = this.createContextMenuManager(targetID);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(viewer, manager));
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = menuMgr.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction actionItem;
                    IContributionItem item = iContributionItemArray[n2];
                    if (item instanceof ActionContributionItem && (actionItem = ((ActionContributionItem)item).getAction()) instanceof SynchronizeModelAction) {
                        ((SynchronizeModelAction)actionItem).selectionChanged(viewer.getSelection());
                    }
                    ++n2;
                }
            }
        });
        viewer.getControl().setMenu(menu);
        this.registerContextMenu(viewer, menuMgr);
    }

    protected MenuManager createContextMenuManager(String targetID) {
        return new MenuManager(targetID);
    }

    protected void registerContextMenu(StructuredViewer viewer, MenuManager menuMgr) {
        String targetID = this.getContextMenuId(viewer);
        if (targetID != null) {
            IWorkbenchSite workbenchSite = this.getConfiguration().getSite().getWorkbenchSite();
            IWorkbenchPartSite ws = null;
            if (workbenchSite instanceof IWorkbenchPartSite) {
                ws = (IWorkbenchPartSite)workbenchSite;
            }
            if (ws != null) {
                ws.registerContextMenu(targetID, menuMgr, (ISelectionProvider)viewer);
            }
        }
    }

    protected String getContextMenuId(StructuredViewer viewer) {
        Object o = this.getConfiguration().getProperty("org.eclipse.team.ui.P_OBJECT_CONTRIBUTION_ID");
        String targetID = o instanceof String ? (String)o : null;
        return targetID;
    }

    protected void fillContextMenu(StructuredViewer viewer, IMenuManager manager) {
        this.addContextMenuGroups(manager);
        this.getActionGroup().setContext(new ActionContext(viewer.getSelection()));
        this.getActionGroup().fillContextMenu(manager);
    }

    protected void addContextMenuGroups(IMenuManager manager) {
        String[] groups;
        String[] o = this.getConfiguration().getProperty("org.eclipse.team.ui.P_CONTEXT_MENU");
        if (!(o instanceof String[])) {
            o = ISynchronizePageConfiguration.DEFAULT_CONTEXT_MENU;
        }
        String[] stringArray = groups = o;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            manager.add((IContributionItem)new Separator(group));
            ++n2;
        }
    }

    protected void fillActionBars(IActionBars actionBars) {
        this.getActionGroup().fillActionBars(actionBars);
        this.updateActionBars(this.getViewer().getStructuredSelection());
        Object input = this.getViewer().getInput();
        if (input instanceof ISynchronizeModelElement) {
            this.getActionGroup().modelChanged((ISynchronizeModelElement)input);
        }
    }

    protected void updateActionBars(IStructuredSelection selection) {
        SynchronizePageActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    protected SynchronizePageActionGroup getActionGroup() {
        return (SynchronizePageActionGroup)((Object)this.getConfiguration());
    }

    private String getGroupId(String group) {
        return ((SynchronizePageConfiguration)this.getConfiguration()).getGroupId(group);
    }
}

