/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2;

import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIPacket;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;

public class EthernetIIEndpoint
extends ProtocolEndpoint {
    private final byte[] fMacAddress;

    public EthernetIIEndpoint(EthernetIIPacket packet, boolean isSourceEndpoint) {
        super(packet, isSourceEndpoint);
        this.fMacAddress = isSourceEndpoint ? packet.getSourceMacAddress() : packet.getDestinationMacAddress();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        result = endpoint == null ? 0 : endpoint.hashCode();
        result = 31 * result + Arrays.hashCode(this.fMacAddress);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EthernetIIEndpoint)) {
            return false;
        }
        EthernetIIEndpoint other = (EthernetIIEndpoint)obj;
        boolean localEquals = Arrays.equals(this.fMacAddress, other.fMacAddress);
        if (!localEquals) {
            return false;
        }
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        if (endpoint != null) {
            return endpoint.equals(other.getParentEndpoint());
        }
        return true;
    }

    @Override
    public String toString() {
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        if (endpoint == null) {
            return ConversionHelper.toMacAddress(this.fMacAddress);
        }
        return endpoint.toString().equals("") ? ConversionHelper.toMacAddress(this.fMacAddress) : String.valueOf(endpoint.toString()) + '/' + ConversionHelper.toMacAddress(this.fMacAddress);
    }
}

