/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.annotations;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.tmf.core.annotations.CustomAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.markers.ITimeReferenceProvider;
import org.eclipse.tracecompass.tmf.core.markers.TimeReference;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.AbstractTmfTraceAdapterFactory;
import org.eclipse.tracecompass.tmf.core.trace.ICyclesConverter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CustomAnnotationProviderTest {
    private static final int ALPHA = 10;
    private static final String COLOR_STR = "#010101";
    private static final RGBAColor COLOR = new RGBAColor(1, 1, 1, 10);
    private static final RGBAColor ODD_COLOR = new RGBAColor(1, 1, 1, 0);
    private static final String RED_STR = "red";
    private static final RGBAColor RED = new RGBAColor(255, 0, 0, 10);
    private static final String INVALID_STR = "invalid";
    private static final RGBAColor DEFAULT = new RGBAColor(0, 0, 0, 10);
    private static ITmfTrace fTrace;
    private static AbstractTmfTraceAdapterFactory fFactory;
    private CustomAnnotationProvider fProvider;

    @BeforeClass
    public static void beforeClass() {
        fFactory = new TmfTraceStubAdapterFactory();
        TmfTraceAdapterManager.registerFactory((IAdapterFactory)fFactory, TmfTraceStub.class);
        fTrace = TmfTestTrace.A_TEST_10K.getTrace();
    }

    @AfterClass
    public static void afterClass() {
        if (fTrace != null) {
            fTrace.dispose();
        }
        TmfTraceAdapterManager.unregisterFactory((IAdapterFactory)fFactory);
        fFactory.dispose();
    }

    @Before
    public void before() {
        this.fProvider = new CustomAnnotationProvider(fTrace, null);
    }

    @Test
    public void testSimple() {
        MarkerSet set = new MarkerSet("name", "id");
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Collections.emptyList(), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        Marker.PeriodicMarker markerA = new Marker.PeriodicMarker("A", "A %d", "a", "ref.a", COLOR_STR, 10.0, "ms", Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(4L)), 20L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        set.addMarker((Marker)markerA);
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Arrays.asList("A"), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        List<Annotation> annotationList = this.getAnnotationList("A", 100000000L, 200000000L, 1000L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)annotationList.toString(), (long)13L, (long)annotationList.size());
        int i = 0;
        while (i < annotationList.size()) {
            long t = (long)(i + 9) * 10000000L;
            int index = i + 9 - 2;
            int labelIndex = index % 5;
            RGBAColor color = index % 2 == 0 ? COLOR : ODD_COLOR;
            CustomAnnotationProviderTest.validateAnnotation(annotationList.get(i), t, 10000000L, "A", String.format("A %d", labelIndex), color);
            ++i;
        }
    }

    @Test
    public void testSubmarkers() {
        MarkerSet set = new MarkerSet("name", "id");
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Collections.emptyList(), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        Marker.PeriodicMarker markerA = new Marker.PeriodicMarker("A", "A %d", "a", "ref.a", COLOR_STR, 10.0, "ms", Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(4L)), 20L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        set.addMarker((Marker)markerA);
        this.fProvider.configure(set);
        SubMarker.SplitMarker markerB = new SubMarker.SplitMarker("B", "B %d", "b", COLOR_STR, Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1000L)), (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        markerA.addSubMarker((SubMarker)markerB);
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Arrays.asList("A", "B"), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        List<Annotation> annotationList = this.getAnnotationList("B", 100000000L, 200000000L, 10000L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)annotationList.size());
        annotationList = this.getAnnotationList("B", 100000000L, 200000000L, 1000L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)10002L, (long)annotationList.size());
        int i = 0;
        while (i < annotationList.size()) {
            long t = (long)(i + 9999) * 10000L;
            int index = i + 9999 - 2000;
            int labelIndex = 1 + index % 1000;
            RGBAColor color = labelIndex % 2 == 0 ? COLOR : ODD_COLOR;
            CustomAnnotationProviderTest.validateAnnotation(annotationList.get(i), t, 10000L, "B", String.format("B %d", labelIndex), color);
            ++i;
        }
    }

    @Test
    public void testOffset() {
        MarkerSet set = new MarkerSet("name", "id");
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Collections.emptyList(), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        Marker.PeriodicMarker markerC = new Marker.PeriodicMarker("C", "C %d", "c", "ref.c", COLOR_STR, 10.0, "cycles", Range.atLeast((Comparable)Long.valueOf(0L)), -10L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        set.addMarker((Marker)markerC);
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Arrays.asList("C"), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        List<Annotation> annotationList = this.getAnnotationList("C", 1000L, 2000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)28L, (long)annotationList.size());
        int i = 0;
        while (i < annotationList.size()) {
            long t = (long)(i + 24) * 40L;
            int index = i + 24 - 25 + 1;
            RGBAColor color = index % 2 == 0 ? COLOR : ODD_COLOR;
            CustomAnnotationProviderTest.validateAnnotation(annotationList.get(i), t, 40L, "C", String.format("C %d", index), color);
            ++i;
        }
    }

    @Test
    public void testIrregular() {
        MarkerSet set = new MarkerSet("name", "id");
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Collections.emptyList(), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        Marker.PeriodicMarker markerD = new Marker.PeriodicMarker("D", "D %d", "d", "ref.d", COLOR_STR, 40.0, "ns", Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(49L)), 0L, (RangeSet)ImmutableRangeSet.builder().add(Range.closed((Comparable)Long.valueOf(30L), (Comparable)Long.valueOf(31L))).add(Range.singleton((Comparable)Long.valueOf(40L))).build());
        set.addMarker((Marker)markerD);
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Arrays.asList("D"), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        List<Annotation> annotationList = this.getAnnotationList("D", 0L, 4000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)6L, (long)annotationList.size());
        int i = 0;
        long t = 0L;
        while (t < 4000L) {
            int index = (int)(t / 40L) % 50;
            if ((long)index == 30L || (long)index == 31L || (long)index == 40L) {
                Annotation annotation = annotationList.get(i++);
                RGBAColor color = index % 2 == 0 ? COLOR : ODD_COLOR;
                CustomAnnotationProviderTest.validateAnnotation(annotation, t, 40L, "D", String.format("D %d", index), color);
            }
            t += 40L;
        }
    }

    @Test
    public void testWeightedWithSubmarkers() {
        MarkerSet set = new MarkerSet("name", "id");
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Collections.emptyList(), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        Marker.PeriodicMarker markerD = new Marker.PeriodicMarker("D", "D %d", "d", "ref.d", COLOR_STR, 40.0, "ns", Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(49L)), 0L, (RangeSet)ImmutableRangeSet.builder().add(Range.closed((Comparable)Long.valueOf(30L), (Comparable)Long.valueOf(31L))).add(Range.singleton((Comparable)Long.valueOf(40L))).build());
        set.addMarker((Marker)markerD);
        SubMarker.WeightedMarker markerE = new SubMarker.WeightedMarker("E");
        markerD.addSubMarker((SubMarker)markerE);
        MarkerSegment segmentE1 = new MarkerSegment("E1 %d", "e1", RED_STR, 2);
        markerE.addSegment(segmentE1);
        MarkerSegment segmentE2 = new MarkerSegment("E2 %d", "e2", "", 1);
        markerE.addSegment(segmentE2);
        MarkerSegment segmentE3 = new MarkerSegment("E3 %d", "e3", INVALID_STR, 3);
        markerE.addSegment(segmentE3);
        this.fProvider.configure(set);
        CustomAnnotationProviderTest.assertAnnotationCategoriesModelResponse(Arrays.asList("D", "E"), (TmfModelResponse<AnnotationCategoriesModel>)this.fProvider.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor()));
        List<Annotation> annotationList = this.getAnnotationList("E", 0L, 2000L, 1L, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)6L, (long)annotationList.size());
        int i = 0;
        long t = 0L;
        while (t < 2000L) {
            int index = (int)(t / 40L) % 50;
            if ((long)index == 30L || (long)index == 31L || (long)index == 40L) {
                CustomAnnotationProviderTest.validateAnnotation(annotationList.get(i), t, 13L, "E", String.format("E1 %d", 0), RED);
                CustomAnnotationProviderTest.validateAnnotation(annotationList.get(++i), t + 20L, 20L, "E", String.format("E3 %d", 2), DEFAULT);
                ++i;
            }
            t += 40L;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<@NonNull Annotation> getAnnotationList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ImmutableMap fetchParameters = ImmutableMap.of((Object)"requested_marker_categories", Collections.singleton(category), (Object)"requested_times", (Object)StateSystemUtils.getTimes((long)startTime, (long)endTime, (long)resolution));
        @NonNull TmfModelResponse response = this.fProvider.fetchAnnotations((Map)fetchParameters, monitor);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        AnnotationModel model = (AnnotationModel)response.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(Collections.singleton(category), model.getAnnotations().keySet());
        return new ArrayList<Annotation>((Collection)model.getAnnotations().get(category));
    }

    private static void assertAnnotationCategoriesModelResponse(List<String> expectedCategories, TmfModelResponse<AnnotationCategoriesModel> response) {
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)response.getStatus());
        AnnotationCategoriesModel model = (AnnotationCategoriesModel)response.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(expectedCategories, (Object)model.getAnnotationCategories());
    }

    private static void validateAnnotation(Annotation annotation, long time, long duration, String category, String label, RGBAColor color) {
        String annotationText = annotation.toString();
        Assert.assertEquals((String)annotationText, (long)time, (long)annotation.getTime());
        Assert.assertEquals((String)annotationText, (long)duration, (long)annotation.getDuration());
        Assert.assertEquals((String)annotationText, (long)-1L, (long)annotation.getEntryId());
        Assert.assertEquals((String)annotationText, (Object)label, (Object)annotation.getLabel());
        Assert.assertEquals((String)annotationText, (Object)CustomAnnotationProviderTest.createStyle(color), (Object)annotation.getStyle());
    }

    private static OutputElementStyle createStyle(RGBAColor color) {
        String colorString = color.toString().substring(0, 7);
        return new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)colorString, (Object)"color", (Object)colorString, (Object)"opacity", (Object)Float.valueOf((float)((double)color.getAlpha() / 255.0))));
    }

    private static final class TmfTraceStubAdapterFactory
    extends AbstractTmfTraceAdapterFactory {
        private TmfTraceStubAdapterFactory() {
        }

        protected <T> @Nullable T getTraceAdapter(@NonNull ITmfTrace trace, Class<T> adapterType) {
            if (ICyclesConverter.class.equals(adapterType)) {
                ICyclesConverter adapter = new ICyclesConverter(){

                    public long cyclesToNanos(long cycles) {
                        return cycles * 4L;
                    }

                    public long nanosToCycles(long nanos) {
                        return nanos / 4L;
                    }
                };
                return adapterType.cast(adapter);
            }
            if (ITimeReferenceProvider.class.equals(adapterType)) {
                ITimeReferenceProvider adapter = new ITimeReferenceProvider(){

                    public TimeReference apply(String referenceId) {
                        if ("ref.c".equals(referenceId)) {
                            return new TimeReference(1000L, 0L);
                        }
                        return null;
                    }
                };
                return adapterType.cast(adapter);
            }
            return null;
        }

        public Class<?>[] getAdapterList() {
            return new Class[]{ICyclesConverter.class, ITimeReferenceProvider.class};
        }
    }
}

