/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class TypeDeclarationLocator
extends PatternLocator {
    protected TypeDeclarationPattern pattern;

    public TypeDeclarationLocator(TypeDeclarationPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        if (this.pattern.simpleName == null || this.matchesName(this.pattern.simpleName, node.name)) {
            return nodeSet.addMatch((ASTNode)node, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int resolveLevel(ASTNode node) {
        if (!(node instanceof TypeDeclaration)) {
            return 0;
        }
        return this.resolveLevel((Binding)((TypeDeclaration)node).binding);
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding type = (TypeBinding)binding;
        switch (this.pattern.typeSuffix) {
            case 'C': {
                if (type.isClass()) break;
                return 0;
            }
            case '\n': {
                if (type.isClass() || type.isInterface() && !type.isAnnotationType()) break;
                return 0;
            }
            case '\t': {
                if (type.isClass() || type.isEnum()) break;
                return 0;
            }
            case 'I': {
                if (type.isInterface() && !type.isAnnotationType()) break;
                return 0;
            }
            case '\u000b': {
                if (type.isInterface() || type.isAnnotationType()) break;
                return 0;
            }
            case 'E': {
                if (type.isEnum()) break;
                return 0;
            }
            case 'A': {
                if (type.isAnnotationType()) break;
                return 0;
            }
        }
        if (this.matchModule(this.pattern, type) == 0) {
            return 0;
        }
        if (this.pattern instanceof QualifiedTypeDeclarationPattern) {
            QualifiedTypeDeclarationPattern qualifiedPattern = (QualifiedTypeDeclarationPattern)this.pattern;
            return this.resolveLevelForType(qualifiedPattern.simpleName, qualifiedPattern.qualification, type);
        }
        char[] enclosingTypeName = this.pattern.enclosingTypeNames == null ? null : CharOperation.concatWith((char[][])this.pattern.enclosingTypeNames, (char)'.');
        return this.resolveLevelForType(this.pattern.simpleName, this.pattern.pkg, enclosingTypeName, type);
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[] enclosingNamePattern, TypeBinding type) {
        if (enclosingNamePattern == null) {
            return this.resolveLevelForType(simpleNamePattern, qualificationPattern, type);
        }
        if (qualificationPattern == null) {
            return this.resolveLevelForType(simpleNamePattern, enclosingNamePattern, type);
        }
        if (type instanceof ProblemReferenceBinding) {
            return 0;
        }
        char[] fullQualificationPattern = CharOperation.concat((char[])qualificationPattern, (char[])enclosingNamePattern, (char)'.');
        if (CharOperation.equals((char[])this.pattern.pkg, (char[])CharOperation.concatWith((char[][])type.getPackage().compoundName, (char)'.'))) {
            return this.resolveLevelForType(simpleNamePattern, fullQualificationPattern, type);
        }
        return 0;
    }

    private HashSet<String> getModuleGraph(String mName, TypeDeclarationPattern typePattern, HashSet<String> mGraph) {
        mGraph.add(mName);
        SearchPattern modulePattern = SearchPattern.createPattern(mName, 12, 0, typePattern.getMatchRule());
        if (modulePattern == null) {
            return mGraph;
        }
        final HashSet tmpGraph = new HashSet();
        JavaSearchParticipant participant = new JavaSearchParticipant(){

            @Override
            public void locateMatches(SearchDocument[] indexMatches, SearchPattern mPattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
                MatchLocator matchLocator = new MatchLocator(mPattern, requestor, scope, monitor);
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                matchLocator.locateMatches(indexMatches);
                this.addRequiredModules(matchLocator);
            }

            private void addRequiredModules(MatchLocator matchLocator) {
                if (matchLocator.matchBinding == null) {
                    return;
                }
                for (Binding b : matchLocator.matchBinding.values()) {
                    if (!(b instanceof ModuleBinding) || ((ModuleBinding)b).moduleName == null) continue;
                    ModuleBinding m = (ModuleBinding)b;
                    tmpGraph.add(new String(m.moduleName));
                    ModuleBinding[] moduleBindingArray = m.getAllRequiredModules();
                    int n = moduleBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModuleBinding r = moduleBindingArray[n2];
                        char[] name = r.moduleName;
                        if (name != null && !CharOperation.equals((char[])name, (char[])CharOperation.NO_CHAR)) {
                            tmpGraph.add(new String(name));
                        }
                        ++n2;
                    }
                }
            }
        };
        SearchRequestor requestor = new SearchRequestor(){

            @Override
            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                System.out.println(searchMatch.toString());
            }
        };
        try {
            new SearchEngine().search(modulePattern, new SearchParticipant[]{participant}, JavaModelManager.getJavaModelManager().getWorkspaceScope(), requestor, null);
        }
        catch (CoreException coreException) {}
        mGraph.addAll(tmpGraph);
        return mGraph;
    }

    private char[][] getModuleList(TypeDeclarationPattern typePattern) {
        if (!typePattern.moduleGraph) {
            return typePattern.moduleNames;
        }
        if (typePattern.moduleGraphElements != null) {
            return typePattern.moduleGraphElements;
        }
        typePattern.moduleGraphElements = CharOperation.NO_CHAR_CHAR;
        List<String> moduleList = Arrays.asList(CharOperation.toStrings((char[][])typePattern.moduleNames));
        int sz = moduleList.size();
        HashSet<String> mGraph = new HashSet<String>();
        int i = 0;
        while (i < sz) {
            mGraph = this.getModuleGraph(moduleList.get(i), typePattern, mGraph);
            ++i;
        }
        sz = mGraph.size();
        if (sz > 0) {
            String[] ar = mGraph.toArray(new String[0]);
            char[][] tmp = new char[sz][];
            int i2 = 0;
            while (i2 < sz) {
                tmp[i2] = ar[i2].toCharArray();
                ++i2;
            }
            typePattern.moduleGraphElements = tmp;
        }
        return typePattern.moduleGraphElements;
    }

    private int matchModule(TypeDeclarationPattern typePattern, TypeBinding type) {
        if (!(type instanceof ReferenceBinding)) {
            return 1;
        }
        ReferenceBinding reference = (ReferenceBinding)type;
        ModuleBinding module = reference.module();
        if (module == null || module.moduleName == null || typePattern.moduleNames == null) {
            return 2;
        }
        String bindModName = new String(module.moduleName);
        if (typePattern.modulePatterns == null) {
            char[][] moduleList;
            char[][] cArray = moduleList = this.getModuleList(typePattern);
            int n = moduleList.length;
            int n2 = 0;
            while (n2 < n) {
                char[] m = cArray[n2];
                int ret = this.matchNameValue(m, module.moduleName);
                if (ret != 0) {
                    return ret;
                }
                ++n2;
            }
        } else {
            Pattern[] patternArray = typePattern.modulePatterns;
            int n = typePattern.modulePatterns.length;
            int n3 = 0;
            while (n3 < n) {
                Pattern p = patternArray[n3];
                Matcher matcher = p.matcher(bindModName);
                if (matcher.matches()) {
                    return 3;
                }
                ++n3;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

