/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.TokenTraverser;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TextEditsBuilder
extends TokenTraverser {
    private final String source;
    private TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private final StringBuilder buffer;
    private final List<Token> stringLiteralsInLine = new ArrayList<Token>();
    private final List<TextEdit> edits = new ArrayList<TextEdit>();
    private final List<IRegion> regions;
    private int currentRegion = 0;
    private TextEditsBuilder childBuilder;
    private final TextEditsBuilder parent;
    private int alignChar;
    private int sourceLimit;
    private int parentTokenIndex;

    public TextEditsBuilder(String source, List<IRegion> regions, TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.source = source;
        this.tm = tokenManager;
        this.options = options;
        this.regions = this.adaptRegions(regions);
        this.alignChar = this.options.align_with_spaces ? 2 : this.options.tab_char;
        this.sourceLimit = source.length();
        this.parent = null;
        this.buffer = new StringBuilder();
    }

    private TextEditsBuilder(TextEditsBuilder parent) {
        this.buffer = parent.buffer;
        this.parent = parent;
        this.source = parent.source;
        this.options = parent.options;
        this.regions = parent.regions;
        this.alignChar = 2;
    }

    private List<IRegion> adaptRegions(List<IRegion> givenRegions) {
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        Region previous = null;
        for (IRegion region : givenRegions) {
            Token token;
            int start = region.getOffset();
            int end = start + region.getLength() - 1;
            int sourceStart = this.tm.get((int)0).originalStart;
            if (start > sourceStart) {
                token = this.tm.get(this.tm.findIndex(start, -1, false));
                if ((token.tokenType == 1002 || token.tokenType == 1003) && start <= token.originalEnd) {
                    start = token.originalStart;
                }
            }
            if (end > start && end > sourceStart) {
                token = this.tm.get(this.tm.findIndex(end, -1, false));
                if ((token.tokenType == 1002 || token.tokenType == 1003) && end < token.originalEnd) {
                    end = token.originalEnd;
                }
            }
            if (previous != null && previous.getOffset() + previous.getLength() >= start) {
                result.remove(result.size() - 1);
                start = previous.getOffset();
            }
            if (end + 1 == this.source.length()) {
                ++end;
            }
            Region adapted = new Region(start, end - start + 1);
            result.add((IRegion)adapted);
            previous = adapted;
        }
        return result;
    }

    @Override
    protected boolean token(Token token, int index) {
        this.bufferWhitespaceBefore(token, index);
        List<Token> structure = token.getInternalStructure();
        if (token.tokenType == 1001) {
            this.handleSingleLineComment(token, index);
        } else if (structure != null && !structure.isEmpty()) {
            this.handleStructuredToken(token, index);
        } else {
            this.flushBuffer(token.originalStart);
            if (token.isToEscape()) {
                this.buffer.append(this.tm.toString(token));
                this.flushBuffer(token.originalEnd + 1);
            } else {
                this.counter = token.originalEnd + 1;
            }
        }
        if (token.tokenType == 60) {
            this.stringLiteralsInLine.add(token);
        }
        if (this.getNext() == null) {
            int i = 0;
            while (i < token.getLineBreaksAfter()) {
                this.bufferLineSeparator(null, i + 1 == token.getLineBreaksAfter());
                ++i;
            }
            char lastChar = this.source.charAt(this.sourceLimit - 1);
            if (token.getLineBreaksAfter() == 0 && (lastChar == '\r' || lastChar == '\n')) {
                this.bufferLineSeparator(null, false);
            }
            this.flushBuffer(this.sourceLimit);
        }
        return true;
    }

    private void bufferWhitespaceBefore(Token token, int index) {
        if (this.getLineBreaksBefore() > 0) {
            this.stringLiteralsInLine.clear();
            if (this.getLineBreaksBefore() > 1) {
                Token indentToken = null;
                if (this.options.indent_empty_lines && token.tokenType != 0) {
                    if (index == 0) {
                        indentToken = token;
                    } else {
                        boolean isBlockIndent = token.getWrapPolicy() != null && token.getWrapPolicy().wrapMode == Token.WrapMode.BLOCK_INDENT;
                        Token previous = this.tm.get(this.tm.findFirstTokenInLine(index - 1, true, !isBlockIndent));
                        indentToken = token.getIndent() > previous.getIndent() ? token : previous;
                    }
                }
                int i = 1;
                while (i < this.getLineBreaksBefore()) {
                    this.bufferLineSeparator(token, true);
                    if (indentToken != null) {
                        this.bufferIndent(indentToken, index);
                    }
                    ++i;
                }
            }
            this.bufferLineSeparator(token, false);
            this.bufferAlign(token, index);
            this.bufferIndent(token, index);
        } else if (index == 0 && this.parent == null) {
            this.bufferIndent(token, index);
        } else if (!this.bufferAlign(token, index) && this.isSpaceBefore()) {
            this.buffer.append(' ');
        }
    }

    private void bufferLineSeparator(Token token, boolean emptyLine) {
        if (this.parent == null) {
            this.buffer.append(this.options.line_separator);
            return;
        }
        boolean isTextBlock = token != null && token.tokenType == 61;
        this.parent.counter = this.counter;
        this.parent.bufferLineSeparator(null, false);
        if (!isTextBlock || !emptyLine || this.options.indent_empty_lines) {
            this.parent.bufferIndent(this.parent.tm.get(this.parentTokenIndex), this.parentTokenIndex);
        }
        this.counter = this.parent.counter;
        if (isTextBlock) {
            return;
        }
        if (token != null && token.tokenType == 0) {
            return;
        }
        if (this.getNext() == null && !emptyLine) {
            return;
        }
        boolean asteriskFound = false;
        int searchLimit = token != null ? token.originalStart : this.sourceLimit;
        int i = this.counter;
        while (i < searchLimit) {
            char c = this.source.charAt(i);
            if (c == '*') {
                this.buffer.append(' ');
                this.flushBuffer(i);
                while (i + 1 < this.sourceLimit && this.source.charAt(i + 1) == '*') {
                    ++i;
                }
                this.counter = i + 1;
                c = this.source.charAt(i + 1);
                if (c != '\r' && c != '\n' || !emptyLine) {
                    this.buffer.append(' ');
                }
                asteriskFound = true;
                break;
            }
            if (!ScannerHelper.isWhitespace((char)c)) break;
            ++i;
        }
        if (!asteriskFound) {
            this.buffer.append(" * ");
        }
    }

    private void bufferIndent(Token token, int index) {
        int indent = token.getIndent();
        if (this.getCurrent() != null && this.getCurrent() != token) {
            indent += this.getCurrent().getEmptyLineIndentAdjustment();
        }
        int spaces = 0;
        if (this.options.use_tabs_only_for_leading_indentations && this.options.tab_char != 2) {
            boolean isWrappedBlockComment;
            Token.WrapPolicy wrapPolicy = token.getWrapPolicy();
            boolean bl = isWrappedBlockComment = this.childBuilder != null && this.childBuilder.parentTokenIndex == index;
            if (isWrappedBlockComment) {
                Token lineStart = this.tm.get(this.tm.findFirstTokenInLine(index));
                spaces = token.getIndent() - lineStart.getIndent();
                token = lineStart;
                wrapPolicy = token.getWrapPolicy();
            }
            while (wrapPolicy != null) {
                Token parentLineStart = this.tm.get(this.tm.findFirstTokenInLine(wrapPolicy.wrapParentIndex));
                if (wrapPolicy.wrapMode != Token.WrapMode.BLOCK_INDENT) {
                    spaces += token.getIndent() - parentLineStart.getIndent();
                }
                if (wrapPolicy == (token = parentLineStart).getWrapPolicy()) {
                    assert (wrapPolicy == Token.WrapPolicy.FORCE_FIRST_COLUMN || wrapPolicy == Token.WrapPolicy.DISABLE_WRAP);
                    break;
                }
                wrapPolicy = token.getWrapPolicy();
            }
        }
        TextEditsBuilder.appendIndentationString(this.buffer, this.options.tab_char, this.options.tab_size, indent - spaces, spaces);
    }

    public static void appendIndentationString(StringBuilder target, int tabChar, int tabSize, int indent, int additionalSpaces) {
        int spacesCount = additionalSpaces;
        int tabsCount = 0;
        switch (tabChar) {
            case 2: {
                spacesCount += indent;
                break;
            }
            case 1: {
                if (tabSize <= 0) break;
                tabsCount += indent / tabSize;
                if (indent % tabSize <= 0) break;
                ++tabsCount;
                break;
            }
            case 4: {
                if (tabSize > 0) {
                    tabsCount += indent / tabSize;
                    spacesCount += indent % tabSize;
                    break;
                }
                spacesCount += indent;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized tab char: " + tabChar);
            }
        }
        char[] indentChars = new char[tabsCount + spacesCount];
        Arrays.fill(indentChars, 0, tabsCount, '\t');
        Arrays.fill(indentChars, tabsCount, indentChars.length, ' ');
        target.append(indentChars);
    }

    private boolean bufferAlign(Token token, int index) {
        int align = token.getAlign();
        int alignmentChar = this.alignChar;
        if (align == 0 && this.getLineBreaksBefore() == 0 && this.parent != null) {
            align = token.getIndent();
            token.setAlign(align);
            alignmentChar = 2;
        }
        if (align == 0) {
            return false;
        }
        int currentPositionInLine = 0;
        if (this.getLineBreaksBefore() > 0) {
            if (this.parent == null) {
                currentPositionInLine = this.tm.toIndent(token.getIndent(), token.getWrapPolicy() != null);
            }
        } else {
            currentPositionInLine = this.tm.getPositionInLine(index - 1);
            currentPositionInLine += this.tm.getLength(this.tm.get(index - 1), currentPositionInLine);
        }
        if (currentPositionInLine >= align) {
            return false;
        }
        int tabSize = this.options.tab_size;
        switch (alignmentChar) {
            case 2: {
                while (currentPositionInLine++ < align) {
                    this.buffer.append(' ');
                }
                break;
            }
            case 1: {
                while (currentPositionInLine < align && tabSize > 0) {
                    this.buffer.append('\t');
                    currentPositionInLine += tabSize - currentPositionInLine % tabSize;
                }
                break;
            }
            case 4: {
                while (tabSize > 0 && currentPositionInLine + tabSize - currentPositionInLine % tabSize <= align) {
                    this.buffer.append('\t');
                    currentPositionInLine += tabSize - currentPositionInLine % tabSize;
                }
                while (currentPositionInLine++ < align) {
                    this.buffer.append(' ');
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized align char: " + alignmentChar);
            }
        }
        return true;
    }

    private void flushBuffer(int currentPosition) {
        String buffered = this.buffer.toString();
        boolean sourceMatch = this.source.startsWith(buffered, this.counter) && this.counter + buffered.length() == currentPosition;
        while (!sourceMatch && this.currentRegion < this.regions.size()) {
            IRegion region = this.regions.get(this.currentRegion);
            if (currentPosition < region.getOffset()) break;
            int regionEnd = region.getOffset() + region.getLength();
            if (this.counter >= regionEnd) {
                ++this.currentRegion;
                continue;
            }
            if (this.currentRegion == this.regions.size() - 1 || this.regions.get(this.currentRegion + 1).getOffset() > currentPosition) {
                this.edits.add((TextEdit)this.getReplaceEdit(this.counter, currentPosition, buffered, region));
                break;
            }
            IRegion nextRegion = this.regions.get(this.currentRegion + 1);
            int bestSplit = 0;
            int bestSplitScore = Integer.MAX_VALUE;
            int i = 0;
            while (i < buffered.length()) {
                ReplaceEdit edit1 = this.getReplaceEdit(this.counter, regionEnd, buffered.substring(0, i), region);
                ReplaceEdit edit2 = this.getReplaceEdit(regionEnd, currentPosition, buffered.substring(i), nextRegion);
                int score = edit1.getLength() + edit1.getText().length() + edit2.getLength() + edit2.getText().length();
                if (score < bestSplitScore) {
                    bestSplit = i;
                    bestSplitScore = score;
                }
                ++i;
            }
            this.edits.add((TextEdit)this.getReplaceEdit(this.counter, regionEnd, buffered.substring(0, bestSplit), region));
            buffered = buffered.substring(bestSplit);
            this.counter = regionEnd;
        }
        this.buffer.setLength(0);
        this.counter = currentPosition;
    }

    private ReplaceEdit getReplaceEdit(int editStart, int editEnd, String text, IRegion region) {
        int breaksToPreserve;
        int breaksOutsideRegion;
        int breaksInReplacement;
        int regionEnd = region.getOffset() + region.getLength();
        if (editStart < region.getOffset() && regionEnd < editEnd) {
            int breaksAfterRegion;
            breaksInReplacement = this.tm.countLineBreaksBetween(text, 0, text.length());
            int breaksBeforeRegion = this.tm.countLineBreaksBetween(this.source, editStart, region.getOffset());
            if (breaksBeforeRegion + (breaksAfterRegion = this.tm.countLineBreaksBetween(this.source, regionEnd, editEnd)) > breaksInReplacement) {
                text = "";
                editStart = region.getOffset();
                editEnd = regionEnd;
            }
        }
        if (region.getOffset() > editStart && this.isOnlyWhitespace(text)) {
            breaksInReplacement = this.tm.countLineBreaksBetween(text, 0, text.length());
            breaksOutsideRegion = this.tm.countLineBreaksBetween(this.source, editStart, region.getOffset());
            breaksToPreserve = breaksInReplacement - breaksOutsideRegion;
            text = this.adaptReplaceText(text, breaksToPreserve, false, region.getOffset() - 1);
            editStart = region.getOffset();
        }
        if (regionEnd < editEnd && this.isOnlyWhitespace(text)) {
            breaksInReplacement = this.tm.countLineBreaksBetween(text, 0, text.length());
            breaksOutsideRegion = this.tm.countLineBreaksBetween(this.source, regionEnd, editEnd);
            breaksToPreserve = breaksInReplacement - breaksOutsideRegion;
            text = this.adaptReplaceText(text, breaksToPreserve, true, regionEnd);
            editEnd = regionEnd;
        }
        return new ReplaceEdit(editStart, editEnd - editStart, text);
    }

    private boolean isOnlyWhitespace(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!ScannerHelper.isWhitespace((char)text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String adaptReplaceText(String text, int breaksToPreserve, boolean isRegionEnd, int regionEdge) {
        int i = isRegionEnd ? 0 : text.length() - 1;
        int direction = isRegionEnd ? 1 : -1;
        int preservedBreaks = 0;
        while (i >= 0 && i < text.length()) {
            assert (ScannerHelper.isWhitespace((char)text.charAt(i)));
            char c1 = text.charAt(i);
            if (c1 == '\r' || c1 == '\n') {
                char c2;
                if (preservedBreaks >= breaksToPreserve) break;
                ++preservedBreaks;
                int i2 = i + direction;
                if (i2 >= 0 && i2 < text.length() && ((c2 = text.charAt(i2)) == '\r' || c2 == '\n') && c2 != c1) {
                    i = i2;
                }
            }
            i += direction;
        }
        text = isRegionEnd ? text.substring(0, i) : text.substring(i + 1);
        int textPos = isRegionEnd ? text.length() - 1 : 0;
        int sourcePos = regionEdge;
        block1: while (textPos >= 0 && textPos < text.length() && sourcePos >= 0 && sourcePos < this.source.length()) {
            char c2;
            char c1 = text.charAt(textPos);
            if (c1 == (c2 = this.source.charAt(sourcePos)) && (c1 == ' ' || c1 == '\t')) {
                textPos -= direction;
                sourcePos += direction;
                continue;
            }
            if (c1 == '\t' && c2 == ' ') {
                i = 0;
                while (i < this.options.tab_size) {
                    if (i < this.options.tab_size - 1 && ((sourcePos += direction) < 0 || sourcePos >= this.source.length() || this.source.charAt(sourcePos) != ' ')) continue block1;
                    ++i;
                }
                textPos -= direction;
                continue;
            }
            if (c2 != '\t' || c1 != ' ') break;
            i = 0;
            while (i < this.options.tab_size) {
                if (i < this.options.tab_size - 1 && ((textPos -= direction) < 0 || textPos >= text.length() || text.charAt(textPos) != ' ')) continue block1;
                ++i;
            }
            sourcePos += direction;
        }
        text = isRegionEnd ? text.substring(0, textPos + 1) : text.substring(textPos);
        return text;
    }

    private void handleSingleLineComment(Token lineComment, int index) {
        List<Token> structure = lineComment.getInternalStructure();
        if (structure == null) {
            this.flushBuffer(lineComment.originalStart);
            this.counter = lineComment.originalEnd + 1;
            return;
        }
        if (structure.get((int)0).tokenType == 1000) {
            this.flushBuffer(structure.get((int)0).originalStart);
        } else {
            this.flushBuffer(lineComment.originalStart);
        }
        int i = 0;
        while (i < structure.size()) {
            Token fragment = structure.get(i);
            if (fragment.getLineBreaksBefore() > 0) {
                this.bufferLineSeparator(fragment, false);
                if (this.parent != null) {
                    this.bufferAlign(lineComment, index);
                }
                this.bufferIndent(fragment, index);
            } else if (fragment.isSpaceBefore() && i > 0) {
                this.buffer.append(' ');
            }
            if (fragment.hasNLSTag()) {
                int tagNumber = this.stringLiteralsInLine.indexOf(fragment.getNLSTag());
                assert (tagNumber >= 0);
                this.buffer.append("//$NON-NLS-").append(tagNumber + 1).append("$");
            } else if (fragment.originalStart < this.counter) {
                this.buffer.append(this.tm.toString(fragment));
            } else {
                this.flushBuffer(fragment.originalStart);
                this.counter = fragment.originalEnd + 1;
            }
            ++i;
        }
        if (lineComment.originalEnd > lineComment.originalStart) {
            this.flushBuffer(lineComment.originalEnd + 1);
        }
    }

    private void handleStructuredToken(Token comment, int index) {
        this.flushBuffer(comment.originalStart);
        if (this.childBuilder == null) {
            this.childBuilder = new TextEditsBuilder(this);
        }
        this.childBuilder.traverseInternalStructure(comment, index);
        this.edits.addAll(this.childBuilder.edits);
        this.childBuilder.edits.clear();
        this.counter = this.childBuilder.sourceLimit;
    }

    private void traverseInternalStructure(Token token, int index) {
        List<Token> structure = token.getInternalStructure();
        this.tm = new TokenManager(structure, this.parent.tm);
        this.counter = token.originalStart;
        this.sourceLimit = token.originalEnd + 1;
        this.parentTokenIndex = index;
        this.traverse(structure, 0);
    }

    public void processComment(Token commentToken) {
        assert (commentToken.isComment());
        if (commentToken.tokenType == 1001) {
            this.handleSingleLineComment(commentToken, this.tm.indexOf(commentToken));
        } else {
            this.handleStructuredToken(commentToken, this.tm.indexOf(commentToken));
        }
    }

    public List<TextEdit> getEdits() {
        return this.edits;
    }

    public void setAlignChar(int alignChar) {
        this.alignChar = alignChar;
    }
}

