/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.ContentTypeSpecializationComparator;
import org.eclipse.ui.internal.genericeditor.GenericContentTypeRelatedExtension;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class PresentationReconcilerRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.presentationReconcilers";
    private Map<IConfigurationElement, GenericContentTypeRelatedExtension<IPresentationReconciler>> extensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IPresentationReconciler>>();
    private boolean outOfSync = true;

    public PresentationReconcilerRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.outOfSync = true;
        }, EXTENSION_POINT_ID);
    }

    public List<IPresentationReconciler> getPresentationReconcilers(ISourceViewer sourceViewer, ITextEditor editor, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        return this.extensions.values().stream().filter(ext -> contentTypes.contains(ext.targetContentType)).filter(ext -> ext.matches(sourceViewer, editor)).sorted(new ContentTypeSpecializationComparator()).map(GenericContentTypeRelatedExtension::createDelegate).collect(Collectors.toList());
    }

    private void sync() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.extensions.containsKey(extension)) {
                try {
                    this.extensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }
}

