/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ConcurrentNeutralValueMap;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.e4.core.internal.contexts.IEclipseContextDebugger;
import org.eclipse.e4.core.internal.contexts.StrongIterable;
import org.eclipse.e4.core.internal.contexts.TrackableComputationExt;
import org.eclipse.e4.core.internal.contexts.ValueComputation;
import org.eclipse.e4.core.internal.contexts.WeakGroupedListenerList;
import org.eclipse.e4.core.internal.contexts.osgi.ContextDebugHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EclipseContext
implements IEclipseContext {
    public static final String PARENT = "parentContext";
    public static final String DEBUG_STRING = "debugString";
    public static final String ANONYMOUS_CONTEXT_NAME = "Anonymous Context";
    private WeakGroupedListenerList weakListeners = new WeakGroupedListenerList();
    private Map<String, ValueComputation> localValueComputations = new ConcurrentHashMap<String, ValueComputation>();
    protected final ConcurrentNeutralValueMap<String, Object> localValues = new ConcurrentNeutralValueMap();
    private Set<String> modifiable;
    private List<Computation> waiting;
    private final Collection<WeakReference<EclipseContext>> children = new ConcurrentLinkedDeque<WeakReference<EclipseContext>>();
    private WeakReference<EclipseContext> selfRef;
    private final StrongIterable<EclipseContext> childIterable = new StrongIterable<EclipseContext>(this.children);
    private Set<IContextDisposalListener> notifyOnDisposal = new HashSet<IContextDisposalListener>();
    private static ThreadLocal<Stack<Computation>> currentComputation = new ThreadLocal();
    private ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private Map<Reference<?>, TrackableComputationExt> activeComputations = Collections.synchronizedMap(new HashMap());
    private Set<TrackableComputationExt> activeRATs = Collections.synchronizedSet(new HashSet());
    private static final Object[] nullArgs = new Object[1];
    public static final String ACTIVE_CHILD = "activeChildContext";
    private static final IEclipseContextDebugger debugAddOn = ContextDebugHelper.getDebugger();

    public EclipseContext(IEclipseContext parent) {
        this.setParent(parent);
        if (parent == null) {
            this.waiting = Collections.synchronizedList(new ArrayList());
        }
        if (debugAddOn != null) {
            debugAddOn.notify(this, IEclipseContextDebugger.EventType.CONSTRUCTED, null);
        }
    }

    public Iterable<EclipseContext> getChildren() {
        return this.childIterable;
    }

    @Override
    public boolean containsKey(String name) {
        this.trackAccess(name);
        return this.containsKey(name, false);
    }

    public boolean containsKey(String name, boolean localOnly) {
        if (this.isSetLocally(name)) {
            return true;
        }
        if (localOnly) {
            return false;
        }
        EclipseContext parent = this.getParent();
        return parent != null && parent.containsKey(name, localOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        for (EclipseContext childContext : this.getChildren()) {
            childContext.dispose();
        }
        ContextChangeEvent event = new ContextChangeEvent(this, 3, null, null, null);
        HashSet<Computation> allComputations = new HashSet<Computation>();
        allComputations.addAll(this.activeComputations.values());
        allComputations.addAll(this.activeRATs);
        this.activeComputations.clear();
        this.activeRATs.clear();
        LinkedHashSet<Scheduled> scheduled = new LinkedHashSet<Scheduled>();
        allComputations.addAll(this.getListeners());
        this.weakListeners.clear();
        for (Computation computation2 : allComputations) {
            computation2.handleInvalid(event, scheduled);
        }
        this.processScheduled(scheduled);
        Set<IContextDisposalListener> set = this.notifyOnDisposal;
        synchronized (set) {
            for (IContextDisposalListener listener : this.notifyOnDisposal) {
                listener.disposed(this);
            }
            this.notifyOnDisposal.clear();
        }
        this.localValueComputations.values().removeIf(computation -> {
            computation.dispose();
            return true;
        });
        EclipseContext eclipseContext = this.getParent();
        EclipseContext rootContext = null;
        if (eclipseContext != null) {
            rootContext = this.getRoot();
            if (this == eclipseContext.getActiveChild()) {
                eclipseContext.set(ACTIVE_CHILD, null);
            }
        }
        this.localValues.clear();
        if (eclipseContext != null) {
            EventAdmin admin;
            this.selfRef.clear();
            if (rootContext != null) {
                rootContext.cleanup();
            }
            if ((admin = eclipseContext.get(EventAdmin.class)) != null) {
                Event osgiEvent = new Event("org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE", Map.of("org.eclipse.e4.core.contexts.IEclipseContext", this));
                admin.sendEvent(osgiEvent);
            }
        }
        if (debugAddOn != null) {
            debugAddOn.notify(this, IEclipseContextDebugger.EventType.DISPOSED, null);
        }
    }

    @Override
    public Object get(String name) {
        this.trackAccess(name);
        return this.internalGet(this, name, false);
    }

    @Override
    public Object getLocal(String name) {
        this.trackAccess(name);
        return this.internalGet(this, name, true);
    }

    public Object internalGet(EclipseContext originatingContext, String name, boolean local) {
        IEclipseContext parent;
        Object result;
        ValueComputation valueComputation;
        if (this == originatingContext && (valueComputation = this.localValueComputations.get(name)) != null && (result = valueComputation.get()) != IInjector.NOT_A_VALUE) {
            return result;
        }
        Object result2 = null;
        ConcurrentNeutralValueMap.Value<Object> value = this.localValues.getValue(name);
        if (value.isPresent()) {
            result2 = value.unwrapped();
            if (result2 == null) {
                return null;
            }
        } else {
            result2 = this.lookup(name, originatingContext);
        }
        if (result2 != null) {
            if (result2 instanceof IContextFunction) {
                ValueComputation valueComputation2 = new ValueComputation(name, originatingContext, (IContextFunction)result2);
                result2 = valueComputation2.get();
                originatingContext.localValueComputations.put(name, valueComputation2);
            }
            if (result2 != IInjector.NOT_A_VALUE) {
                return result2;
            }
        }
        if (!local && (parent = (IEclipseContext)this.localValues.get(PARENT)) != null) {
            return ((EclipseContext)parent).internalGet(originatingContext, name, local);
        }
        return null;
    }

    public void invalidate(String name, int eventType, Object oldValue, Object newValue, Set<Scheduled> scheduled) {
        Set<Computation> namedComputations;
        ContextChangeEvent event = new ContextChangeEvent(this, eventType, null, name, oldValue);
        ValueComputation newComputation = this.localValueComputations.computeIfPresent(name, (k, computation) -> {
            if (computation.shouldRemove(event)) {
                this.weakListeners.remove((Computation)computation);
                return null;
            }
            return computation;
        });
        if (newComputation != null) {
            newComputation.handleInvalid(event, scheduled);
        }
        if ((namedComputations = this.weakListeners.getListeners(name)) != null && !namedComputations.isEmpty()) {
            for (Computation listener : namedComputations) {
                listener.handleInvalid(event, scheduled);
            }
        }
        boolean addedOrRemoved = eventType == 1 || eventType == 2;
        for (EclipseContext childContext : this.getChildren()) {
            if (addedOrRemoved && childContext.isSetLocally(name)) continue;
            childContext.invalidate(name, eventType, oldValue, newValue, scheduled);
        }
    }

    protected boolean isLocalEquals(String name, Object newValue) {
        ConcurrentNeutralValueMap.Value<Object> value = this.localValues.getValue(name);
        if (!value.isPresent()) {
            return false;
        }
        return value.unwrapped() == newValue;
    }

    private boolean isSetLocally(String name) {
        return this.localValues.containsKey(name);
    }

    @Override
    public void remove(String name) {
        if (this.isSetLocally(name)) {
            Object oldValue = this.localValues.remove(name);
            LinkedHashSet<Scheduled> scheduled = new LinkedHashSet<Scheduled>();
            this.invalidate(name, 2, oldValue, IInjector.NOT_A_VALUE, scheduled);
            this.processScheduled(scheduled);
        }
    }

    @Override
    public void runAndTrack(RunAndTrack runnable) {
        TrackableComputationExt computation = new TrackableComputationExt(runnable, this);
        ContextChangeEvent event = new ContextChangeEvent(this, 0, null, null, null);
        boolean result = computation.update(event);
        if (result) {
            Reference<Object> ref = computation.getReference();
            if (ref != null) {
                this.activeComputations.put(ref, computation);
            } else {
                this.activeRATs.add(computation);
            }
        }
    }

    public void removeRAT(Computation computation) {
        this.weakListeners.remove(computation);
        this.activeRATs.remove(computation);
    }

    protected void processScheduled(Set<Scheduled> scheduledList) {
        for (Scheduled scheduled : scheduledList) {
            scheduled.runnable.update(scheduled.event);
        }
    }

    @Override
    public void set(String name, Object value) {
        Reference<Object> ref;
        if (PARENT.equals(name)) {
            this.setParent((IEclipseContext)value);
            return;
        }
        ConcurrentNeutralValueMap.Value<Object> old = this.localValues.putAndGetOld(name, value);
        boolean containsKey = old.isPresent();
        Object oldValue = old.unwrapped();
        if (!containsKey || oldValue != value) {
            LinkedHashSet<Scheduled> scheduled = new LinkedHashSet<Scheduled>();
            this.invalidate(name, 1, oldValue, value, scheduled);
            this.processScheduled(scheduled);
        }
        if ((ref = this.referenceQueue.poll()) != null) {
            ContextChangeEvent event = new ContextChangeEvent(this, 4, nullArgs, null, null);
            while (ref != null) {
                TrackableComputationExt obsoleteComputation = this.activeComputations.remove(ref);
                if (obsoleteComputation != null) {
                    obsoleteComputation.update(event);
                }
                ref = this.referenceQueue.poll();
            }
        }
    }

    @Override
    public void modify(String name, Object value) {
        LinkedHashSet<Scheduled> scheduled = new LinkedHashSet<Scheduled>();
        if (!this.internalModify(name, value, scheduled)) {
            this.set(name, value);
        }
        this.processScheduled(scheduled);
    }

    public boolean internalModify(String name, Object value, Set<Scheduled> scheduled) {
        boolean containsKey = this.localValues.containsKey(name);
        if (containsKey) {
            if (!this.checkModifiable(name)) {
                String tmp = "Variable " + name + " is not modifiable in the context " + this;
                throw new IllegalArgumentException(tmp);
            }
            Object oldValue = this.localValues.putAndGetOld(name, value).unwrapped();
            if (oldValue != value) {
                this.invalidate(name, 1, oldValue, value, scheduled);
            }
            return true;
        }
        EclipseContext parent = this.getParent();
        if (parent != null) {
            return parent.internalModify(name, value, scheduled);
        }
        return false;
    }

    @Override
    public EclipseContext getParent() {
        return (EclipseContext)this.localValues.get(PARENT);
    }

    @Override
    public void setParent(IEclipseContext parent) {
        EclipseContext parentContext = (EclipseContext)this.localValues.get(PARENT);
        if (parent == parentContext) {
            return;
        }
        if (parentContext != null) {
            this.selfRef.clear();
        }
        LinkedHashSet<Scheduled> scheduled = new LinkedHashSet<Scheduled>();
        EclipseContext newParent = (EclipseContext)parent;
        this.handleReparent(newParent, scheduled);
        this.localValues.put(PARENT, parent);
        if (parent != null) {
            this.selfRef = new WeakReference<EclipseContext>(this);
            newParent.addChild(this.selfRef);
        }
        this.processScheduled(scheduled);
    }

    public String toString() {
        Object debugString = this.localValues.get(DEBUG_STRING);
        return debugString instanceof String ? (String)debugString : ANONYMOUS_CONTEXT_NAME;
    }

    private void trackAccess(String name) {
        Stack<Computation> current = EclipseContext.getCalculatedComputations();
        if (current.isEmpty()) {
            return;
        }
        Computation computation = current.peek();
        if (computation == null) {
            return;
        }
        this.addDependency(name, computation);
    }

    public void addDependency(String name, Computation computation) {
        this.weakListeners.add(name, computation);
    }

    @Override
    public void declareModifiable(String name) {
        if (name == null) {
            return;
        }
        if (this.modifiable == null) {
            this.modifiable = new HashSet<String>(3);
        }
        this.modifiable.add(name);
        this.localValues.putIfAbsent(name, null);
    }

    private boolean checkModifiable(String name) {
        if (this.modifiable == null) {
            return false;
        }
        return this.modifiable.contains(name);
    }

    public void removeListenersTo(Object object) {
        if (object == null) {
            return;
        }
        ContextChangeEvent event = new ContextChangeEvent(this, 4, new Object[]{object}, null, null);
        Set<Computation> comps = this.getListeners();
        for (Computation computation : comps) {
            if (!(computation instanceof TrackableComputationExt)) continue;
            ((TrackableComputationExt)computation).update(event);
        }
    }

    public Set<Computation> getListeners() {
        return this.weakListeners.getListeners();
    }

    private void handleReparent(EclipseContext newParent, Set<Scheduled> scheduled) {
        this.processWaiting();
        HashSet<String> usedNames = new HashSet<String>();
        this.collectDependentNames(usedNames);
        for (String name : usedNames) {
            Object newValue;
            if (this.localValues.containsKey(name)) continue;
            Object oldValue = this.get(name);
            Object object = newValue = newParent != null ? newParent.internalGet(this, name, false) : null;
            if (oldValue == newValue) continue;
            this.invalidate(name, 1, oldValue, newValue, scheduled);
        }
        this.invalidateLocalComputations(scheduled);
    }

    protected void invalidateLocalComputations(Set<Scheduled> scheduled) {
        ContextChangeEvent event = new ContextChangeEvent(this, 1, null, null, null);
        this.localValueComputations.values().removeIf(computation -> {
            this.weakListeners.remove((Computation)computation);
            computation.handleInvalid(event, scheduled);
            return true;
        });
        for (EclipseContext c : this.getChildren()) {
            c.invalidateLocalComputations(scheduled);
        }
    }

    private void collectDependentNames(Set<String> usedNames) {
        Set<String> names = this.weakListeners.getNames();
        usedNames.addAll(names);
        for (EclipseContext childContext : this.getChildren()) {
            childContext.collectDependentNames(usedNames);
        }
    }

    @Override
    public void processWaiting() {
        EclipseContext parent = this.getParent();
        if (parent != null) {
            parent.processWaiting();
            return;
        }
        if (this.waiting == null || this.waiting.isEmpty()) {
            return;
        }
        Computation[] ls = this.waiting.toArray(new Computation[this.waiting.size()]);
        this.waiting.clear();
        ContextChangeEvent event = new ContextChangeEvent(this, 5, null, null, null);
        Computation[] computationArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            Computation element = computationArray[n2];
            if (element instanceof TrackableComputationExt) {
                ((TrackableComputationExt)element).update(event);
            }
            ++n2;
        }
    }

    public void addWaiting(Computation cp) {
        EclipseContext parent = this.getParent();
        if (parent != null) {
            parent.addWaiting(cp);
            return;
        }
        if (this.waiting == null) {
            this.waiting = Collections.synchronizedList(new ArrayList());
        }
        this.waiting.add(cp);
    }

    protected EclipseContext getRoot() {
        EclipseContext root;
        EclipseContext current = this;
        do {
            root = current;
        } while ((current = current.getParent()) != null);
        return root;
    }

    private void addChild(WeakReference<EclipseContext> ref) {
        this.children.add(ref);
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return clazz.cast(this.get(clazz.getName()));
    }

    @Override
    public boolean containsKey(Class<?> clazz) {
        return this.containsKey(clazz.getName());
    }

    @Override
    public <T> void set(Class<T> clazz, T value) {
        this.set(clazz.getName(), value);
    }

    @Override
    public void remove(Class<?> clazz) {
        this.remove(clazz.getName());
    }

    @Override
    public <T> T getLocal(Class<T> clazz) {
        return clazz.cast(this.getLocal(clazz.getName()));
    }

    @Override
    public <T> void modify(Class<T> clazz, T value) {
        this.modify(clazz.getName(), value);
    }

    @Override
    public void declareModifiable(Class<?> clazz) {
        this.declareModifiable(clazz.getName());
    }

    @Override
    public IEclipseContext createChild() {
        return new EclipseContext(this);
    }

    @Override
    public IEclipseContext createChild(String name) {
        IEclipseContext result = this.createChild();
        result.set(DEBUG_STRING, name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOnDisposal(IContextDisposalListener listener) {
        Set<IContextDisposalListener> set = this.notifyOnDisposal;
        synchronized (set) {
            this.notifyOnDisposal.add(listener);
        }
    }

    @Override
    public IEclipseContext getActiveChild() {
        this.trackAccess(ACTIVE_CHILD);
        return (EclipseContext)this.internalGet(this, ACTIVE_CHILD, true);
    }

    @Override
    public IEclipseContext getActiveLeaf() {
        IEclipseContext activeContext = this;
        IEclipseContext child = this.getActiveChild();
        while (child != null) {
            activeContext = child;
            child = child.getActiveChild();
        }
        return activeContext;
    }

    @Override
    public void activate() {
        EclipseContext parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (this == parent.getActiveChild()) {
            return;
        }
        parent.set(ACTIVE_CHILD, this);
        if (debugAddOn != null) {
            debugAddOn.notify(this, IEclipseContextDebugger.EventType.ACTIVATED, null);
        }
    }

    @Override
    public void activateBranch() {
        IEclipseContext i = this;
        while (i != null) {
            i.activate();
            i = i.getParent();
        }
    }

    @Override
    public void deactivate() {
        EclipseContext parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (this != parent.getActiveChild()) {
            return;
        }
        parent.set(ACTIVE_CHILD, null);
        if (debugAddOn != null) {
            debugAddOn.notify(this, IEclipseContextDebugger.EventType.DEACTIVATED, null);
        }
    }

    public Map<String, Object> localData() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.localValues.size());
        this.localValues.forEach((k, v) -> {
            if (!(v instanceof IContextFunction)) {
                result.put((String)k, v);
            }
        });
        return result;
    }

    public Map<String, Object> localContextFunction() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.localValues.size());
        this.localValues.forEach((k, v) -> {
            if (v instanceof IContextFunction) {
                result.put((String)k, v);
            }
        });
        return result;
    }

    public Map<String, Object> cachedCachedContextFunctions() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.localValueComputations.size());
        for (Map.Entry<String, ValueComputation> entry : this.localValueComputations.entrySet()) {
            ValueComputation r;
            if (entry.getValue() == null || (r = entry.getValue()) == IInjector.NOT_A_VALUE) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Set<String> getRawListenerNames() {
        return this.weakListeners.getNames();
    }

    public Set<Computation> getListeners(String name) {
        return this.weakListeners.getListeners(name);
    }

    public static Stack<Computation> getCalculatedComputations() {
        Stack<Computation> current = currentComputation.get();
        if (current == null) {
            current = new Stack();
            currentComputation.set(current);
        }
        return current;
    }

    public void pushComputation(Computation comp) {
        Stack<Computation> current = EclipseContext.getCalculatedComputations();
        current.push(comp);
    }

    public boolean hasComputation(Computation comp) {
        Stack<Computation> current = EclipseContext.getCalculatedComputations();
        boolean hasComputation = current.contains(comp);
        return hasComputation;
    }

    public void popComputation(Computation comp) {
        Stack<Computation> current = EclipseContext.getCalculatedComputations();
        Computation ended = current.pop();
        if (ended != comp) {
            throw new IllegalArgumentException("Internal error: Invalid nested computation processing");
        }
    }

    protected Object lookup(String name, EclipseContext originatingContext) {
        return null;
    }

    @Override
    public <T> T getActive(Class<T> clazz) {
        return clazz.cast(this.getActive(clazz.getName()));
    }

    @Override
    public Object getActive(String name) {
        return this.getActiveLeaf().get(name);
    }

    public WeakReference<Object> trackedWeakReference(Object object) {
        return new WeakReference<Object>(object, this.referenceQueue);
    }

    public void cleanup() {
        for (EclipseContext childContext : this.getChildren()) {
            childContext.cleanup();
        }
        this.weakListeners.cleanup();
    }

    static class Scheduled {
        public TrackableComputationExt runnable;
        public ContextChangeEvent event;

        public Scheduled(TrackableComputationExt runnable, ContextChangeEvent event) {
            this.runnable = runnable;
            this.event = event;
        }

        public int hashCode() {
            return 31 * (31 + this.event.hashCode()) + this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Scheduled other = (Scheduled)obj;
            return Objects.equals(this.event, other.event) && Objects.equals(this.runnable, other.runnable);
        }
    }
}

