/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public class CTFJsonMetadataNode
implements ICTFMetadataNode {
    @SerializedName(value="type")
    private String fType;
    @SerializedName(value="user-attributes")
    private Map<String, String> fUserAttributes;
    private ICTFMetadataNode fParent;
    private Map<String, ICTFMetadataNode> fChildren;
    private ArrayList<ICTFMetadataNode> fChildrenList;
    private final String fValue;

    public CTFJsonMetadataNode(ICTFMetadataNode parent, String type, String value) {
        this.fParent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.fType = Objects.requireNonNull(type);
        this.fValue = value;
        this.fChildren = new HashMap<String, ICTFMetadataNode>();
        this.fChildrenList = new ArrayList();
    }

    @Override
    public ICTFMetadataNode getParent() {
        return this.fParent;
    }

    @Override
    public ICTFMetadataNode getChild(String id) {
        return this.fChildren.get(id);
    }

    @Override
    public ICTFMetadataNode getChild(int index) {
        return this.fChildrenList.get(index);
    }

    @Override
    public String getText() {
        return this.fValue;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    @Override
    public void setParent(ICTFMetadataNode node) {
        this.fParent = node;
    }

    @Override
    public void addChild(ICTFMetadataNode node) {
        this.fChildren.put(node.getType(), node);
        this.fChildrenList.add(node);
    }

    @Override
    public List<ICTFMetadataNode> getChildren() {
        return this.fChildrenList;
    }

    @Override
    public int getChildCount() {
        return this.fChildrenList.size();
    }

    @Override
    public ICTFMetadataNode getFirstChildWithType(String typeDeclaratorList) {
        for (ICTFMetadataNode child : this.fChildrenList) {
            if (!child.getType().equals(typeDeclaratorList)) continue;
            return child;
        }
        return null;
    }

    public Map<String, String> getUserAttributes() {
        return this.fUserAttributes;
    }

    public void setType(String type) {
        this.fType = Objects.requireNonNull(type);
    }

    public void setChildrenList(List<ICTFMetadataNode> childrenList) {
        this.fChildrenList = (ArrayList)childrenList;
    }

    public void initialize() throws CTFException {
        if (this.fChildren == null) {
            this.fChildren = new HashMap<String, ICTFMetadataNode>();
        }
        if (this.fChildrenList == null) {
            this.fChildrenList = new ArrayList();
        }
        if (this.fType == null) {
            throw new CTFException("type of node cannot be null");
        }
    }
}

