/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import com.google.gson.JsonObject;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.BlobDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasTargetParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.StringDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TypeAliasParser
extends AbstractScopedCommonTreeParser {
    public static final TypeAliasParser INSTANCE = new TypeAliasParser();

    private TypeAliasParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IDeclaration parse(ICTFMetadataNode typealias, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        String aliasString;
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        List<ICTFMetadataNode> children = typealias.getChildren();
        ICTFMetadataNode target = null;
        ICTFMetadataNode alias = null;
        IDeclaration targetDeclaration = null;
        CTFTrace trace = ((Param)param).fTrace;
        if (typealias instanceof JsonStructureFieldMemberMetadataNode) {
            JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)typealias;
            aliasString = member.getName();
            String type = typealias.getType();
            if (!member.getFieldClass().isJsonObject()) throw new ParseException("Field classes that are not Json Objects are not yet supported");
            JsonObject fieldClass = member.getFieldClass().getAsJsonObject();
            if ("fixed-length-unsigned-integer".equals(type)) {
                fieldClass.addProperty("signed", Boolean.valueOf(false));
                targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
            } else if ("static-length-blob".equals(type)) {
                targetDeclaration = BlobDeclarationParser.INSTANCE.parse(typealias, null);
            } else {
                if (!"null-terminated-string".equals(type)) throw new ParseException("Invalid field class");
                targetDeclaration = StringDeclarationParser.INSTANCE.parse(typealias, null);
            }
        } else {
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[113].equals(type)) {
                    target = child;
                    continue;
                }
                if (!CTFParser.tokenNames[112].equals(type)) throw TsdlUtils.childTypeError(child);
                alias = child;
            }
            targetDeclaration = TypeAliasTargetParser.INSTANCE.parse(target, new TypeAliasTargetParser.Param(trace, scope));
            if (targetDeclaration instanceof VariantDeclaration && ((VariantDeclaration)targetDeclaration).isTagged()) {
                throw new ParseException("Typealias of untagged variant is not permitted");
            }
            aliasString = TypeAliasAliasParser.INSTANCE.parse(alias, null);
        }
        scope.registerType(aliasString, targetDeclaration);
        return targetDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

