/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.synchronization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.graph.SyncSpanningTree;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.Messages;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SyncAlgorithmFullyIncremental
extends SynchronizationAlgorithm {
    private static final long serialVersionUID = -1782788842774838830L;
    private static final MathContext fMc = MathContext.DECIMAL128;
    private final List<ConvexHull> fSyncs = new LinkedList<ConvexHull>();
    private transient SyncSpanningTree fTree = null;

    @Override
    public void matchingEnded() {
        this.getStats();
    }

    @Override
    public void init(Collection<ITmfTrace> traces) {
        ITmfTrace[] traceArr = traces.toArray(new ITmfTrace[traces.size()]);
        this.fSyncs.clear();
        int i = 0;
        while (i < traceArr.length) {
            int j = i + 1;
            while (j < traceArr.length) {
                if (!traceArr[i].getHostId().equals(traceArr[j].getHostId())) {
                    ConvexHull algo = new ConvexHull(traceArr[i], traceArr[j]);
                    this.fSyncs.add(algo);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void processMatch(TmfEventDependency match) {
        String host2;
        ITmfTrace trace1 = match.getSource().getTrace();
        ITmfTrace trace2 = match.getDestination().getTrace();
        String host1 = trace1.getHostId();
        if (host1.equals(host2 = trace2.getHostId())) {
            return;
        }
        ConvexHull algo = null;
        for (ConvexHull traceSync : this.fSyncs) {
            if (!traceSync.isForHosts(host1, host2)) continue;
            algo = traceSync;
        }
        if (algo == null) {
            algo = new ConvexHull(trace1, trace2);
            this.fSyncs.add(algo);
        }
        algo.processMatch(match);
        this.invalidateSyncGraph();
    }

    private void invalidateSyncGraph() {
        this.fTree = null;
    }

    @Override
    public ITmfTimestampTransform getTimestampTransform(ITmfTrace trace) {
        return this.getTimestampTransform(trace.getHostId());
    }

    @Override
    public ITmfTimestampTransform getTimestampTransform(String hostId) {
        SyncSpanningTree tree = this.getSyncTree();
        return tree.getTimestampTransform(hostId);
    }

    private SyncSpanningTree getSyncTree() {
        if (this.fTree == null) {
            this.fTree = new SyncSpanningTree(this.getRootNode());
            for (ConvexHull traceSync : this.fSyncs) {
                SynchronizationAlgorithm.SyncQuality q = traceSync.getQuality();
                if (q != SynchronizationAlgorithm.SyncQuality.ACCURATE && q != SynchronizationAlgorithm.SyncQuality.APPROXIMATE && q != SynchronizationAlgorithm.SyncQuality.FAIL) continue;
                String from = traceSync.getReferenceHost();
                String to = traceSync.getOtherHost();
                this.fTree.addSynchronization(from, to, traceSync.getTimestampTransform(to), traceSync.getAccuracy());
            }
        }
        return this.fTree;
    }

    @Override
    public SynchronizationAlgorithm.SyncQuality getSynchronizationQuality(ITmfTrace trace1, ITmfTrace trace2) {
        for (ConvexHull traceSync : this.fSyncs) {
            if (!traceSync.isForHosts(trace1.getHostId(), trace2.getHostId())) continue;
            return traceSync.getQuality();
        }
        return SynchronizationAlgorithm.SyncQuality.ABSENT;
    }

    @Override
    public boolean isTraceSynced(String hostId) {
        ITmfTimestampTransform t = this.getTimestampTransform(hostId);
        return !t.equals(TimestampTransformFactory.getDefaultTransform());
    }

    @Override
    public Map<String, Map<String, Object>> getStats() {
        LinkedHashMap<String, Map<String, Object>> statmap = new LinkedHashMap<String, Map<String, Object>>();
        for (ConvexHull traceSync : this.fSyncs) {
            statmap.put(String.valueOf(traceSync.getReferenceHost()) + " <==> " + traceSync.getOtherHost(), traceSync.getStats());
        }
        return statmap;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ' ' + this.fSyncs.toString();
    }

    private class ConvexHull
    implements Serializable {
        private static final long serialVersionUID = 8309351175030935291L;
        private final String fReferenceHost;
        private final String fReferenceHostName;
        private final String fOtherHost;
        private final String fOtherHostName;
        private @NonNull BigDecimal fAlphamin;
        private @NonNull BigDecimal fBetamax;
        private @NonNull BigDecimal fAlphamax;
        private @NonNull BigDecimal fBetamin;
        private @NonNull BigDecimal fAlpha;
        private @NonNull BigDecimal fBeta;
        private int fNbMatches;
        private int fNbAccurateMatches;
        private SynchronizationAlgorithm.SyncQuality fQuality;
        private transient LinkedList<SyncPoint> fUpperBoundList = new LinkedList();
        private transient LinkedList<SyncPoint> fLowerBoundList = new LinkedList();
        private transient SyncPoint[] fLmax = new SyncPoint[2];
        private transient SyncPoint[] fLmin = new SyncPoint[2];
        private transient Map<String, Object> fStats = new LinkedHashMap<String, Object>();

        public ConvexHull(ITmfTrace trace1, ITmfTrace trace2) {
            String host1 = trace1.getHostId();
            String host2 = trace2.getHostId();
            if (host1.compareTo(host2) > 0) {
                this.fReferenceHost = host2;
                this.fReferenceHostName = trace2.getName();
                this.fOtherHost = host1;
                this.fOtherHostName = trace1.getName();
            } else {
                this.fReferenceHost = host1;
                this.fReferenceHostName = trace1.getName();
                this.fOtherHost = host2;
                this.fOtherHostName = trace2.getName();
            }
            this.fAlpha = BigDecimal.ONE;
            this.fAlphamax = BigDecimal.ONE;
            this.fAlphamin = BigDecimal.ONE;
            this.fBeta = BigDecimal.ZERO;
            this.fBetamax = BigDecimal.ZERO;
            this.fBetamin = BigDecimal.ZERO;
            this.fNbMatches = 0;
            this.fNbAccurateMatches = 0;
            this.fQuality = SynchronizationAlgorithm.SyncQuality.ABSENT;
        }

        protected void processMatch(TmfEventDependency match) {
            SyncPoint p;
            SyncPoint[] otherLine;
            SyncPoint[] line;
            LinkedList<SyncPoint> otherBoundList;
            LinkedList<SyncPoint> boundList;
            int inversionFactor = 1;
            boolean qualify = false;
            ++this.fNbMatches;
            if (match.getSource().getTrace().getHostId().compareTo(match.getDestination().getTrace().getHostId()) > 0) {
                boundList = this.fUpperBoundList;
                otherBoundList = this.fLowerBoundList;
                line = this.fLmin;
                otherLine = this.fLmax;
                p = new SyncPoint(match.getDestination(), match.getSource());
                inversionFactor = 1;
            } else {
                boundList = this.fLowerBoundList;
                otherBoundList = this.fUpperBoundList;
                line = this.fLmax;
                otherLine = this.fLmin;
                p = new SyncPoint(match.getSource(), match.getDestination());
                inversionFactor = -1;
            }
            if (line[0] == null || line[1] == null || p.crossProduct(line[0], line[1]) * (long)inversionFactor > 0L) {
                ++this.fNbAccurateMatches;
                qualify = true;
                this.removeUselessPoints(p, boundList, inversionFactor);
                line[1] = p;
                this.fStats.clear();
            }
            this.adjustBound(line, otherBoundList, inversionFactor);
            if (otherLine[1] != null && !boundList.contains(otherLine[0])) {
                this.adjustBound(otherLine, boundList, inversionFactor * -1);
            }
            if (qualify) {
                this.approximateSync();
            }
        }

        private void approximateSync() {
            if (this.fLmax[0] != null || this.fLmin[0] != null) {
                if (this.getQuality() != SynchronizationAlgorithm.SyncQuality.FAIL) {
                    BigDecimal alphamax = this.fLmax[1].getAlpha(this.fLmax[0]);
                    BigDecimal alphamin = this.fLmin[1].getAlpha(this.fLmin[0]);
                    SynchronizationAlgorithm.SyncQuality quality = null;
                    quality = this.fLmax[0] == null || this.fLmin[0] == null ? SynchronizationAlgorithm.SyncQuality.APPROXIMATE : (alphamax.compareTo(alphamin) > 0 ? SynchronizationAlgorithm.SyncQuality.ACCURATE : SynchronizationAlgorithm.SyncQuality.FAIL);
                    if (quality != SynchronizationAlgorithm.SyncQuality.FAIL) {
                        this.fAlphamax = alphamax;
                        this.fBetamin = this.fLmax[1].getBeta(this.fAlphamax);
                        this.fAlphamin = alphamin;
                        this.fBetamax = this.fLmin[1].getBeta(this.fAlphamin);
                        this.fAlpha = this.fAlphamax.add(this.fAlphamin).divide(BigDecimal.valueOf(2L), fMc);
                        this.fBeta = this.fBetamin.add(this.fBetamax).divide(BigDecimal.valueOf(2L), fMc);
                    }
                    this.setQuality(quality);
                }
            } else if (this.fLmax[0] == null && this.fLmin[1] == null || this.fLmax[1] == null && this.fLmin[0] == null) {
                this.setQuality(SynchronizationAlgorithm.SyncQuality.INCOMPLETE);
            }
        }

        private void adjustBound(SyncPoint[] line, LinkedList<SyncPoint> otherBoundList, int inversionFactor) {
            SyncPoint minPoint = null;
            boolean finishedSearch = false;
            int i = Math.max(0, otherBoundList.indexOf(line[0]));
            while (i < otherBoundList.size() - 1 && !finishedSearch) {
                SyncPoint nextPoint;
                minPoint = otherBoundList.get(i);
                if (minPoint.crossProduct(nextPoint = otherBoundList.get(i + 1), line[1]) * (long)inversionFactor > 0L) {
                    if (nextPoint.getTimeX() < line[1].getTimeX()) {
                        ++i;
                        continue;
                    }
                    line[0] = null;
                    finishedSearch = true;
                    continue;
                }
                line[0] = minPoint;
                finishedSearch = true;
            }
            if (line[0] == null) {
                line[0] = minPoint;
            }
            if (line[0] != null && line[0].getTimeX() > line[1].getTimeX()) {
                line[0] = null;
            }
        }

        private void removeUselessPoints(SyncPoint p, LinkedList<SyncPoint> boundList, int inversionFactor) {
            boolean checkRemove = true;
            while (checkRemove && boundList.size() >= 2) {
                if (p.crossProduct(boundList.get(boundList.size() - 2), boundList.getLast()) * (long)inversionFactor > 0L) {
                    boundList.removeLast();
                    continue;
                }
                checkRemove = false;
            }
            boundList.addLast(p);
        }

        public ITmfTimestampTransform getTimestampTransform(String hostId) {
            if (hostId.equals(this.fOtherHost) && (this.getQuality() == SynchronizationAlgorithm.SyncQuality.ACCURATE || this.getQuality() == SynchronizationAlgorithm.SyncQuality.APPROXIMATE || this.getQuality() == SynchronizationAlgorithm.SyncQuality.FAIL)) {
                return TimestampTransformFactory.createLinear((BigDecimal)NonNullUtils.checkNotNull((Object)BigDecimal.ONE.divide(this.fAlpha, fMc)), (BigDecimal)NonNullUtils.checkNotNull((Object)BigDecimal.valueOf(-1L).multiply(this.fBeta).divide(this.fAlpha, fMc)));
            }
            return TimestampTransformFactory.getDefaultTransform();
        }

        public SynchronizationAlgorithm.SyncQuality getQuality() {
            return this.fQuality;
        }

        public BigDecimal getAccuracy() {
            return this.fAlphamax.subtract(this.fAlphamin);
        }

        public Map<String, Object> getStats() {
            if (this.fStats.size() == 0) {
                String syncQuality = switch (this.getQuality()) {
                    case SynchronizationAlgorithm.SyncQuality.ABSENT -> Messages.SyncAlgorithmFullyIncremental_absent;
                    case SynchronizationAlgorithm.SyncQuality.ACCURATE -> Messages.SyncAlgorithmFullyIncremental_accurate;
                    case SynchronizationAlgorithm.SyncQuality.APPROXIMATE -> Messages.SyncAlgorithmFullyIncremental_approx;
                    case SynchronizationAlgorithm.SyncQuality.INCOMPLETE -> Messages.SyncAlgorithmFullyIncremental_incomplete;
                    default -> Messages.SyncAlgorithmFullyIncremental_fail;
                };
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_refhost, String.valueOf(this.fReferenceHostName) + " (" + this.fReferenceHost + ")");
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_otherhost, String.valueOf(this.fOtherHostName) + " (" + this.fOtherHost + ")");
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_quality, syncQuality);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_alpha, this.fAlpha);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_beta, this.fBeta);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_ub, this.fUpperBoundList.isEmpty() ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fUpperBoundList.size()));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_lb, this.fLowerBoundList.isEmpty() ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fLowerBoundList.size()));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_accuracy, this.getAccuracy().doubleValue());
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_nbmatch, this.fNbMatches == 0 ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fNbMatches));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_nbacc, this.fNbAccurateMatches == 0 ? Messages.SyncAlgorithmFullyIncremental_NA : Integer.valueOf(this.fNbAccurateMatches));
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_refformula, String.valueOf(Messages.SyncAlgorithmFullyIncremental_T_) + this.fReferenceHost);
                this.fStats.put(Messages.SyncAlgorithmFullyIncremental_otherformula, this.fAlpha + Messages.SyncAlgorithmFullyIncremental_mult + Messages.SyncAlgorithmFullyIncremental_T_ + this.fReferenceHost + Messages.SyncAlgorithmFullyIncremental_add + this.fBeta);
            }
            return this.fStats;
        }

        public String getReferenceHost() {
            return this.fReferenceHost;
        }

        public String getOtherHost() {
            return this.fOtherHost;
        }

        public boolean isForHosts(String hostId1, String hostId2) {
            return this.fReferenceHost.equals(hostId1) && this.fOtherHost.equals(hostId2) || this.fReferenceHost.equals(hostId2) && this.fOtherHost.equals(hostId1);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.fUpperBoundList = new LinkedList();
            this.fLowerBoundList = new LinkedList();
            this.fLmax = new SyncPoint[2];
            this.fLmin = new SyncPoint[2];
            this.fStats = new LinkedHashMap<String, Object>();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Between " + this.fReferenceHost + " and " + this.fOtherHost + " [");
            b.append(" alpha " + this.fAlpha + " beta " + this.fBeta + " ]");
            return b.toString();
        }

        private void setQuality(SynchronizationAlgorithm.SyncQuality fQuality) {
            this.fQuality = fQuality;
        }
    }

    private static class SyncPoint {
        private final long x;
        private final long y;

        public SyncPoint(TmfEventDependency.DependencyEvent dependencyEvent, TmfEventDependency.DependencyEvent dependencyEvent2) {
            this.x = dependencyEvent.getTimestamp().getValue();
            this.y = dependencyEvent2.getTimestamp().getValue();
        }

        public long getTimeX() {
            return this.x;
        }

        public long crossProduct(SyncPoint pa, SyncPoint pb) {
            long cp = (pa.x - this.x) * (pb.y - this.y) - (pa.y - this.y) * (pb.x - this.x);
            return cp;
        }

        public @NonNull BigDecimal getAlpha(SyncPoint p1) {
            if (p1 == null) {
                return BigDecimal.ONE;
            }
            BigDecimal deltay = BigDecimal.valueOf(this.y - p1.y);
            BigDecimal deltax = BigDecimal.valueOf(this.x - p1.x);
            if (deltax.equals(BigDecimal.ZERO)) {
                return BigDecimal.ONE;
            }
            return deltay.divide(deltax, fMc);
        }

        public @NonNull BigDecimal getBeta(BigDecimal alpha) {
            return BigDecimal.valueOf(this.y).subtract(alpha.multiply(BigDecimal.valueOf(this.x), fMc));
        }

        public String toString() {
            return String.format("%s (%s,  %s)", this.getClass().getCanonicalName(), this.x, this.y);
        }
    }
}

