/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.model;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.ValidatorHelper;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public abstract class FilterRule
implements IAdaptable {
    protected final String _pattern;
    protected static final String PortableFileDelim = "/";

    public static FilterRule create(IConfigurationElement rule) {
        String name = rule.getName();
        if ("fileext".equals(name)) {
            return new FileExt(rule);
        }
        if ("projectNature".equals(name)) {
            return new ProjectNature(rule);
        }
        if ("file".equals(name)) {
            return File.createFile(rule);
        }
        if ("contentType".equals(name)) {
            return ContentType.createContentType(rule);
        }
        if ("facet".equals(name)) {
            return new Facet(rule);
        }
        if ("pattern".equals(name)) {
            return FilePattern.createFilePattern(rule);
        }
        if ("targetRuntime".equals(name)) {
            return new TargetRuntime(rule);
        }
        return null;
    }

    static FilterRule create(Deserializer des) {
        String type = des.getString();
        if ("fileext".equals(type)) {
            String pattern = des.getString();
            boolean caseSensitive = des.getBoolean();
            return new FileExt(pattern, caseSensitive);
        }
        if ("projectNature".equals(type)) {
            String pattern = des.getString();
            return new ProjectNature(pattern);
        }
        if ("file".equals(type)) {
            String pattern = des.getString();
            boolean caseSensitive = des.getBoolean();
            int fileType = des.getInt();
            return new File(pattern, caseSensitive, fileType);
        }
        if ("contentType".equals(type)) {
            String pattern = des.getString();
            boolean exactMatch = des.getBoolean();
            return new ContentType(pattern, exactMatch);
        }
        if ("facet".equals(type)) {
            String pattern = des.getString();
            return new Facet(pattern, null);
        }
        if ("targetRuntime".equals(type)) {
            String pattern = des.getString();
            return new TargetRuntime(pattern);
        }
        if ("pattern".equals(type)) {
            String pattern = des.getString();
            boolean caseSensitive = des.getBoolean();
            return new FilePattern(pattern, caseSensitive);
        }
        return null;
    }

    public static FilterRule createFile(String pattern, boolean caseSensitive, int type) {
        return new File(pattern, caseSensitive, type);
    }

    public static FilterRule createFileExt(String pattern, boolean caseSensitive) {
        FileExt ext = new FileExt(pattern, caseSensitive);
        return ext;
    }

    public static FilterRule createFacet(String facetId) {
        return new Facet(facetId, null);
    }

    public static FilterRule createProject(String projectNature) {
        return new ProjectNature(projectNature);
    }

    public static FilterRule createContentType(String contentType, boolean exactMatch) {
        return new ContentType(contentType, exactMatch);
    }

    public static FilterRule createTargetRuntime(String targetRuntime) {
        return new TargetRuntime(targetRuntime);
    }

    protected FilterRule(String pattern) {
        this._pattern = pattern;
    }

    public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
        return null;
    }

    public Boolean matchesProject(IProject project) {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getDisplayableType()) + ": " + this._pattern;
    }

    public String getName() {
        return this.toString();
    }

    public String getPattern() {
        return this._pattern;
    }

    public abstract String getType();

    public abstract String getDisplayableType();

    public static boolean asBoolean(String value, boolean aDefault) {
        if (value == null) {
            return aDefault;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return aDefault;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void save(Serializer ser) {
        ser.put(this.getType());
        ser.put(this.getPattern());
    }

    public int hashCodeForConfig() {
        int h = this.getType().hashCode();
        if (this._pattern != null) {
            h += this._pattern.hashCode();
        }
        return h;
    }

    public static final class ContentType
    extends FilterRule {
        private final IContentType _type;
        private final boolean _exactMatch;

        private ContentType(String pattern, boolean exactMatch) {
            super(pattern);
            this._type = Platform.getContentTypeManager().getContentType(pattern);
            this._exactMatch = exactMatch;
        }

        private static ContentType createContentType(IConfigurationElement rule) {
            String pattern = rule.getAttribute("id");
            boolean exactMatch = true;
            String exact = rule.getAttribute("exactMatch");
            if ("false".equals(exact)) {
                exactMatch = false;
            }
            return new ContentType(pattern, exactMatch);
        }

        public String getType() {
            return "contentType";
        }

        public int hashCodeForConfig() {
            int h = super.hashCodeForConfig();
            if (this._exactMatch) {
                h += 301;
            }
            return h;
        }

        public String getDisplayableType() {
            return ValMessages.RuleContentType;
        }

        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._exactMatch);
        }

        public void setData(IConfigurationElement rule) {
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            if (this._type == null) {
                return Boolean.FALSE;
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                IContentType ct = contentTypeWrapper.getContentType(file);
                if (ct == null) {
                    return Boolean.FALSE;
                }
                boolean match = false;
                match = this._exactMatch ? ct.getId().equals(this._type.getId()) : ct.isKindOf(this._type);
                if (match && Tracing.isTraceMatches()) {
                    Tracing.log("FilterRule-01: ", String.valueOf(this.toString()) + " has matched " + resource);
                }
                return match;
            }
            return Boolean.FALSE;
        }

        public String toString() {
            try {
                if (this._exactMatch) {
                    return NLS.bind((String)ValMessages.ContentTypeExact, (Object)this.getDisplayableType(), (Object)this._type.getName().concat(" - ").concat(this._pattern));
                }
                return NLS.bind((String)ValMessages.ContentTypeNotExact, (Object)this.getDisplayableType(), (Object)this._type.getName().concat(" - ").concat(this._pattern));
            }
            catch (NullPointerException nullPointerException) {
                if (this._exactMatch) {
                    return NLS.bind((String)ValMessages.ContentTypeExact, (Object)this.getDisplayableType(), (Object)this._pattern);
                }
                return NLS.bind((String)ValMessages.ContentTypeNotExact, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
        }
    }

    public static final class Facet
    extends FilterRule {
        private final String _versionExpression;
        private String _facetLabel = null;

        private Facet(IConfigurationElement rule) {
            super(rule.getAttribute("id"));
            this._versionExpression = rule.getAttribute("version");
        }

        public Facet(String facetId, String versionExpression) {
            super(facetId);
            this._versionExpression = versionExpression;
            try {
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetId);
                if (facet != null) {
                    this._facetLabel = facet.getLabel();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        public String getType() {
            return "facet";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFacet;
        }

        public Boolean matchesProject(IProject project) {
            try {
                if (this._versionExpression == null) {
                    return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this._pattern);
                }
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this._pattern, (String)this._versionExpression);
            }
            catch (CoreException e) {
                if (Tracing.isLogging()) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
                return Boolean.FALSE;
            }
        }

        public String toString() {
            String facetLabel = this._facetLabel;
            StringBuffer b = new StringBuffer(200);
            b.append(this.getDisplayableType());
            b.append(": ");
            if (this._facetLabel == null) {
                try {
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)this._pattern);
                    facetLabel = facet.getLabel();
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (facetLabel != null && facetLabel.length() > 0) {
                b.append(facetLabel);
                b.append(" - ");
            }
            b.append(this._pattern);
            if (this._versionExpression != null) {
                b.append(" (");
                b.append(this._versionExpression);
                b.append(")");
            }
            return b.toString();
        }
    }

    public static final class File
    extends FilterRuleCaseSensitive {
        private final String _patternAsLowercase;
        private final int _type;
        public static final int FileTypeFile = 1;
        public static final int FileTypeFolder = 2;
        public static final int FileTypeFull = 3;

        private static File createFile(IConfigurationElement rule) {
            String pattern = rule.getAttribute("name");
            if (pattern == null) {
                throw new IllegalStateException(ValMessages.ErrPatternAttrib);
            }
            String type = rule.getAttribute("type");
            if (type == null) {
                throw new IllegalStateException(ValMessages.ErrTypeReq);
            }
            int myType = -1;
            if ("file".equals(type)) {
                myType = 1;
            } else if ("folder".equals(type)) {
                myType = 2;
                if (!pattern.endsWith(FilterRule.PortableFileDelim)) {
                    pattern = String.valueOf(pattern) + FilterRule.PortableFileDelim;
                }
            } else if ("full".equals(type)) {
                myType = 3;
            } else {
                Object[] parms = new Object[]{type, "file", "folder", "full"};
                throw new IllegalStateException(NLS.bind((String)ValMessages.ErrType, (Object[])parms));
            }
            boolean caseSensitive = File.asBoolean(rule.getAttribute("caseSensitive"), false);
            return new File(pattern, caseSensitive, myType);
        }

        private File(String pattern, boolean caseSensitive, int type) {
            super(pattern, caseSensitive);
            this._type = type;
            this._patternAsLowercase = pattern == null ? null : pattern.toLowerCase();
        }

        public String getType() {
            return "file";
        }

        public String getDisplayableType() {
            if (this._type == 2) {
                return ValMessages.RuleFolder;
            }
            if (this._type == 3) {
                return ValMessages.RuleFull;
            }
            return ValMessages.RuleFile;
        }

        public void setData(IConfigurationElement rule) {
        }

        public String toString() {
            if (this.isCaseSensitive()) {
                return NLS.bind((String)ValMessages.FileExtWithCase, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.FileExtWithoutCase, (Object)this.getDisplayableType(), (Object)this._pattern);
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            String name = null;
            switch (this._type) {
                case 1: {
                    name = resource.getName();
                    break;
                }
                case 2: {
                    name = String.valueOf(resource.getProjectRelativePath().removeLastSegments(1).toString()) + FilterRule.PortableFileDelim;
                    break;
                }
                case 3: {
                    name = resource.getProjectRelativePath().toPortableString();
                }
            }
            if (name == null) {
                return Boolean.FALSE;
            }
            if (this.isCaseSensitive()) {
                return name.startsWith(this._pattern);
            }
            return name.toLowerCase().startsWith(this._patternAsLowercase);
        }

        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._type);
        }
    }

    public static final class FileExt
    extends FilterRuleCaseSensitive {
        private FileExt(IConfigurationElement rule) {
            super(rule.getAttribute("ext"), FileExt.asBoolean(rule.getAttribute("caseSensitive"), false));
        }

        private FileExt(String pattern, boolean caseSensitive) {
            super(pattern, caseSensitive);
        }

        public String getType() {
            return "fileext";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFileExt;
        }

        public String getName() {
            return this.toString();
        }

        public String toString() {
            if (this.isCaseSensitive()) {
                return NLS.bind((String)ValMessages.FileExtWithCase, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.FileExtWithoutCase, (Object)this.getDisplayableType(), (Object)this._pattern);
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            String ext = resource.getFileExtension();
            if (this.isCaseSensitive()) {
                return this._pattern.equals(ext);
            }
            return this._pattern.equalsIgnoreCase(ext);
        }
    }

    public static final class FilePattern
    extends FilterRuleCaseSensitive {
        private final Pattern _compiledPattern;

        private static FilePattern createFilePattern(IConfigurationElement rule) {
            String pattern = rule.getAttribute("regex");
            boolean caseSensitive = FilePattern.asBoolean(rule.getAttribute("caseSensitive"), false);
            return new FilePattern(pattern, caseSensitive);
        }

        private FilePattern(String pattern, boolean caseSensitive) {
            super(pattern, caseSensitive);
            Pattern compiledPattern;
            int flags = 0;
            if (caseSensitive) {
                flags = 2;
            }
            this._compiledPattern = compiledPattern = Pattern.compile(pattern, flags);
        }

        public String getDisplayableType() {
            return ValMessages.RulePattern;
        }

        public String getType() {
            return "pattern";
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper wrapper) {
            String name = FilterRule.PortableFileDelim + resource.getProjectRelativePath().toPortableString();
            return this._compiledPattern.matcher(name).matches();
        }
    }

    public static abstract class FilterRuleCaseSensitive
    extends FilterRule {
        private final boolean _caseSensitive;

        public FilterRuleCaseSensitive(String pattern, boolean caseSensitive) {
            super(pattern);
            this._caseSensitive = caseSensitive;
        }

        public int hashCodeForConfig() {
            int h = super.hashCodeForConfig();
            if (this._caseSensitive) {
                h += 401;
            }
            return h;
        }

        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._caseSensitive);
        }

        public boolean isCaseSensitive() {
            return this._caseSensitive;
        }
    }

    public static final class ProjectNature
    extends FilterRule {
        private String patternLabel = null;

        private ProjectNature(IConfigurationElement rule) {
            super(rule.getAttribute("id"));
        }

        public ProjectNature(String projectNature) {
            super(projectNature);
            IProjectNatureDescriptor nature = ResourcesPlugin.getWorkspace().getNatureDescriptor(projectNature);
            if (nature != null) {
                this.patternLabel = nature.getLabel();
            }
        }

        public String getDisplayableType() {
            return ValMessages.RuleProjectNature;
        }

        public String getType() {
            return "projectNature";
        }

        public Boolean matchesProject(IProject project) {
            try {
                return project.hasNature(this._pattern);
            }
            catch (CoreException coreException) {
                return Boolean.FALSE;
            }
        }

        public String toString() {
            if (this.patternLabel != null && this.patternLabel.length() > 0) {
                return String.valueOf(this.getDisplayableType()) + ": " + this.patternLabel.concat(" - ").concat(this._pattern);
            }
            return String.valueOf(this.getDisplayableType()) + ": " + this._pattern;
        }
    }

    public static final class TargetRuntime
    extends FilterRule {
        private String patternLabel = null;

        private TargetRuntime(IConfigurationElement rule) {
            super(rule.getAttribute("id"));
        }

        public TargetRuntime(String targetRuntime) {
            super(targetRuntime);
            String runtime = ValidatorHelper.getRuntimeName(targetRuntime);
            if (runtime != null) {
                this.patternLabel = runtime;
            }
        }

        public String getType() {
            return "targetRuntime";
        }

        public String getDisplayableType() {
            return ValMessages.RuleTargetRuntime;
        }

        public Boolean matchesProject(IProject project) {
            try {
                IRuntime runtime = ValidatorHelper.getTargetRuntime(project);
                if (runtime != null) {
                    return runtime.getName().equals(this._pattern);
                }
            }
            catch (CoreException coreException) {}
            return Boolean.FALSE;
        }

        public String toString() {
            if (this.patternLabel == null) {
                this.patternLabel = ValidatorHelper.getRuntimeName(this._pattern);
            }
            if (this.patternLabel != null && this.patternLabel.length() > 0) {
                return String.valueOf(this.getDisplayableType()) + ": " + this.patternLabel.concat(" - ").concat(this._pattern);
            }
            return String.valueOf(this.getDisplayableType()) + ": " + this._pattern;
        }
    }
}

