/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.scope.LexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.BlobDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndex;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;
import org.eclipse.tracecompass.internal.ctf.core.utils.Utils;

@NonNullByDefault
public class CTFStreamInput
implements IDefinitionScope {
    private static final int MAP_SIZE = 4096;
    private final ICTFStream fStream;
    private final File fFile;
    private final String fFileName;
    private final StreamInputPacketIndex fIndex;
    private long fTimestampEnd;
    private final StructDeclaration fTracePacketHeaderDecl;
    private final StructDeclaration fStreamPacketContextDecl;
    private long fLostSoFar = 0L;
    private boolean fUUIDMismatchWarning = false;

    public CTFStreamInput(ICTFStream stream, File file) {
        this.fStream = stream;
        this.fFile = file;
        this.fFileName = this.fFile.getName();
        this.fIndex = new StreamInputPacketIndex();
        StructDeclaration packetHeader = this.getStream().getTrace().getPacketHeader();
        this.fTracePacketHeaderDecl = packetHeader != null ? packetHeader : new StructDeclaration(1L);
        StructDeclaration packetContextDecl = this.getStream().getPacketContextDecl();
        this.fStreamPacketContextDecl = packetContextDecl != null ? packetContextDecl : new StructDeclaration(1L);
    }

    public ICTFStream getStream() {
        return this.fStream;
    }

    StreamInputPacketIndex getIndex() {
        return this.fIndex;
    }

    public String getFilename() {
        return this.fFileName;
    }

    public long getTimestampEnd() {
        return this.fTimestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.fTimestampEnd = timestampEnd;
    }

    @Override
    public LexicalScope getScopePath() {
        return ILexicalScope.STREAM;
    }

    @Override
    public @Nullable Definition lookupDefinition(@Nullable String lookupPath) {
        return null;
    }

    public void setupIndex() {
        BitBuffer bitBuffer = new BitBuffer();
        ByteOrder byteOrder = this.getStream().getTrace().getByteOrder();
        bitBuffer.setByteOrder(byteOrder);
    }

    public boolean addPacketHeaderIndex() throws CTFException {
        long currentPosBits = 0L;
        if (!this.fIndex.isEmpty()) {
            ICTFPacketDescriptor pos = this.fIndex.lastElement();
            if (pos == null) {
                throw new IllegalStateException("Index contains null packet entries");
            }
            currentPosBits = pos.getOffsetBits() + pos.getPacketSizeBits();
        }
        if (currentPosBits < this.getStreamSizeBits()) {
            return this.fIndex.append(this.createPacketIndexEntry(currentPosBits));
        }
        return false;
    }

    private long getStreamSizeBits() {
        return this.fFile.length() * 8L;
    }

    private ICTFPacketDescriptor createPacketIndexEntry(long dataOffsetbits) throws CTFException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileChannel fc = FileChannel.open(this.fFile.toPath(), StandardOpenOption.READ);){
                if (fc == null) {
                    throw new IOException("Failed to create FileChannel");
                }
                BitBuffer bitBuffer = this.createBitBufferForPacketHeader(fc, dataOffsetbits);
                this.parseTracePacketHeader(bitBuffer);
                long size = fc.size();
                ICTFPacketDescriptor packetIndex = this.parsePacketContext(dataOffsetbits, size, bitBuffer);
                if (packetIndex.getContentSizeBits() > packetIndex.getPacketSizeBits()) {
                    throw new CTFException("Content size (" + packetIndex.getContentSizeBits() + ") > packet size (" + packetIndex.getPacketSizeBits() + ")");
                }
                if (packetIndex.getPacketSizeBits() > size * 8L - packetIndex.getOffsetBits()) {
                    throw new CTFException("Not enough data remaining in the file for the size of this packet");
                }
                return packetIndex;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFException("Failed to create packet index entry", e);
        }
        catch (CTFException e) {
            throw new CTFException("Cannot create packet entry at bit " + dataOffsetbits, e);
        }
    }

    private BitBuffer createBitBufferForPacketHeader(FileChannel fc, long dataOffsetbits) throws CTFException, IOException {
        int maximumSize = this.fStreamPacketContextDecl.getMaximumSize() + this.fTracePacketHeaderDecl.getMaximumSize();
        BitBuffer bitBuffer = new BitBuffer(CTFStreamInput.createPacketBitBuffer(fc, dataOffsetbits / 8L, maximumSize));
        bitBuffer.setByteOrder(this.getStream().getTrace().getByteOrder());
        return bitBuffer;
    }

    private static ByteBuffer getByteBufferAt(FileChannel fc, long position, long size) throws CTFException, IOException {
        return SafeMappedByteBuffer.map(fc, FileChannel.MapMode.READ_ONLY, position, size);
    }

    private static ByteBuffer createPacketBitBuffer(FileChannel fc, long packetOffsetBytes, long maxSize) throws CTFException, IOException {
        long remain = fc.size() - packetOffsetBytes;
        long mapSize = Math.min(remain, 4096L);
        if (maxSize < mapSize) {
            mapSize = maxSize;
        }
        try {
            return CTFStreamInput.getByteBufferAt(fc, packetOffsetBytes, mapSize);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CTFException(e);
        }
    }

    private StructDefinition parseTracePacketHeader(BitBuffer bitBuffer) throws CTFException {
        long streamID;
        int magic;
        IntegerDefinition streamIDDef;
        IntegerDefinition magicDef;
        StructDefinition tracePacketHeaderDef = this.fTracePacketHeaderDecl.createDefinition((IDefinitionScope)this.fStream.getTrace(), ILexicalScope.TRACE_PACKET_HEADER, bitBuffer);
        UUID uuid = null;
        if (this.fStream.getTrace().isCTF2()) {
            magicDef = (IntegerDefinition)tracePacketHeaderDef.lookupRole("packet-magic-number");
            uuidDef = (BlobDefinition)tracePacketHeaderDef.lookupRole("metadata-stream-uuid");
            if (uuidDef != null) {
                uuid = Utils.makeUUID(((BlobDefinition)uuidDef).getBytes());
            }
            streamIDDef = (IntegerDefinition)tracePacketHeaderDef.lookupRole("data-stream-class-id");
        } else {
            magicDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("magic");
            uuidDef = (AbstractArrayDefinition)tracePacketHeaderDef.lookupDefinition("uuid");
            if (uuidDef != null) {
                uuid = Utils.getUUIDfromDefinition((AbstractArrayDefinition)uuidDef);
            }
            streamIDDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("stream_id");
        }
        if (magicDef != null && (magic = (int)magicDef.getValue()) != -1040441407) {
            throw new CTFException("CTF magic mismatch " + Integer.toHexString(magic) + " vs " + Integer.toHexString(-1040441407));
        }
        if (!Objects.equals(this.getStream().getTrace().getUUID(), uuid) && !this.fUUIDMismatchWarning) {
            this.fUUIDMismatchWarning = true;
            Activator.log(2, "Reading CTF trace: UUID mismatch for trace " + String.valueOf(this.getStream().getTrace()));
        }
        if (streamIDDef != null && (streamID = streamIDDef.getValue()) != this.getStream().getId()) {
            throw new CTFException("Stream ID changing within a StreamInput");
        }
        return tracePacketHeaderDef;
    }

    private ICTFPacketDescriptor parsePacketContext(long dataOffsetBits, long fileSizeBytes, BitBuffer bitBuffer) throws CTFException {
        StructDefinition streamPacketContextDef = this.fStreamPacketContextDecl.createDefinition((IDefinitionScope)this, ILexicalScope.STREAM_PACKET_CONTEXT, bitBuffer);
        StreamInputPacketIndexEntry packetIndex = new StreamInputPacketIndexEntry(dataOffsetBits, streamPacketContextDef, fileSizeBytes, this.fLostSoFar, bitBuffer.position());
        this.fLostSoFar = packetIndex.getLostEvents() + this.fLostSoFar;
        this.setTimestampEnd(packetIndex.getTimestampEnd());
        return packetIndex;
    }

    public File getFile() {
        return this.fFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFile.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFStreamInput)) {
            return false;
        }
        CTFStreamInput other = (CTFStreamInput)obj;
        return this.fFile.equals(other.fFile);
    }
}

