/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.IUMap;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.metadata.index.CapabilityIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IdIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IndexProvider;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryIO;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.IPool;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.KeyWithLocale;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.metadata.index.IIndexProvider;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMetadataRepository
extends AbstractMetadataRepository
implements IIndexProvider<IInstallableUnit> {
    private static final String CONTENT_FILENAME = "content";
    private static final String REPOSITORY_TYPE;
    private static final Integer REPOSITORY_VERSION;
    private static final String JAR_EXTENSION = ".jar";
    private static final String XML_EXTENSION = ".xml";
    protected IUMap units = new IUMap();
    protected HashSet<IRepositoryReference> repositories = new HashSet();
    private IIndex<IInstallableUnit> idIndex;
    private IIndex<IInstallableUnit> capabilityIndex;
    private TranslationSupport translationSupport;
    private boolean snapshotNeeded = false;
    private boolean disableSave = false;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    private static File getActualLocation(URI location, String extension) {
        File spec = URIUtil.toFile((URI)location);
        String path = spec.getAbsolutePath();
        if (path.endsWith(new StringBuffer(CONTENT_FILENAME).append(extension).toString())) {
            return spec;
        }
        path = path.endsWith("/") ? new StringBuffer(String.valueOf(path)).append(CONTENT_FILENAME).toString() : new StringBuffer(String.valueOf(path)).append("/content").toString();
        return new File(new StringBuffer(String.valueOf(path)).append(extension).toString());
    }

    public static File getActualLocation(URI location) {
        return LocalMetadataRepository.getActualLocation(location, XML_EXTENSION);
    }

    public LocalMetadataRepository(IProvisioningAgent agent) {
        super(agent);
    }

    public LocalMetadataRepository(IProvisioningAgent agent, URI location, String name, Map<String, String> properties) {
        super(agent, name == null ? (location != null ? location.toString() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        if (!location.getScheme().equals("file")) {
            throw new IllegalArgumentException(new StringBuffer("Invalid local repository location: ").append(location).toString());
        }
        this.save();
    }

    public synchronized void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        if (installableUnits == null || installableUnits.isEmpty()) {
            return;
        }
        if (this.snapshotNeeded) {
            this.units = this.units.clone();
            this.idIndex = null;
            this.snapshotNeeded = false;
        }
        this.units.addAll(installableUnits);
        this.capabilityIndex = null;
        this.save();
    }

    public void addReferences(Collection<? extends IRepositoryReference> references) {
        this.assertModifiable();
        if (this.repositories.addAll(references)) {
            this.save();
        }
    }

    public Collection<IRepositoryReference> getReferences() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public synchronized IIndex<IInstallableUnit> getIndex(String memberName) {
        if ("id".equals(memberName)) {
            this.snapshotNeeded = true;
            if (this.idIndex == null) {
                this.idIndex = new IdIndex(this.units);
            }
            return this.idIndex;
        }
        if ("providedCapabilities".equals(memberName)) {
            this.snapshotNeeded = true;
            if (this.capabilityIndex == null) {
                this.capabilityIndex = new CapabilityIndex(this.units.iterator());
            }
            return this.capabilityIndex;
        }
        return null;
    }

    public synchronized Object getManagedProperty(Object client, String memberName, Object key) {
        if (!(client instanceof IInstallableUnit)) {
            return null;
        }
        IInstallableUnit iu = (IInstallableUnit)client;
        if ("translatedProperties".equals(memberName)) {
            if (this.translationSupport == null) {
                this.translationSupport = new TranslationSupport((IQueryable)this);
            }
            return key instanceof KeyWithLocale ? this.translationSupport.getIUProperty(iu, (KeyWithLocale)key) : this.translationSupport.getIUProperty(iu, key.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(AbstractMetadataRepository.RepositoryState state) {
        LocalMetadataRepository localMetadataRepository = this;
        synchronized (localMetadataRepository) {
            this.setName(state.Name);
            this.setType(state.Type);
            this.setVersion(state.Version.toString());
            this.setProvider(state.Provider);
            this.setDescription(state.Description);
            this.setLocation(state.Location);
            this.setProperties(state.Properties);
            this.units.addAll(state.Units);
            this.repositories.addAll(Arrays.asList(state.Repositories));
        }
        this.publishRepositoryReferences();
    }

    public void publishRepositoryReferences() {
        IProvisioningEventBus bus = (IProvisioningEventBus)this.getProvisioningAgent().getService(IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        List<IRepositoryReference> repositoriesSnapshot = this.createRepositoriesSnapshot();
        for (IRepositoryReference reference : repositoriesSnapshot) {
            boolean isEnabled = (reference.getOptions() & 1) != 0;
            bus.publishEvent((EventObject)new RepositoryEvent(reference.getLocation(), reference.getType(), 4, isEnabled));
        }
    }

    private synchronized List<IRepositoryReference> createRepositoriesSnapshot() {
        if (this.repositories.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        return new ArrayList<IRepositoryReference>(this.repositories);
    }

    public synchronized void initializeAfterLoad(URI aLocation) {
        this.setLocation(aLocation);
    }

    public boolean isModifiable() {
        return true;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return IndexProvider.query((IIndexProvider)this, query, (IProgressMonitor)monitor);
    }

    public synchronized Iterator<IInstallableUnit> everything() {
        this.snapshotNeeded = true;
        return this.units.iterator();
    }

    public synchronized void removeAll() {
        if (this.snapshotNeeded) {
            this.units = new IUMap();
            this.idIndex = null;
            this.snapshotNeeded = false;
        } else {
            this.units.clear();
        }
        this.capabilityIndex = null;
        this.save();
    }

    public synchronized boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        boolean changed = false;
        if (installableUnits != null && !installableUnits.isEmpty()) {
            changed = true;
            if (this.snapshotNeeded) {
                this.units = this.units.clone();
                this.idIndex = null;
                this.snapshotNeeded = false;
            }
            this.units.removeAll(installableUnits);
            this.capabilityIndex = null;
        }
        if (changed) {
            this.save();
        }
        return changed;
    }

    protected void save() {
        if (this.disableSave) {
            return;
        }
        File file = LocalMetadataRepository.getActualLocation(this.getLocation());
        File jarFile = LocalMetadataRepository.getActualLocation(this.getLocation(), JAR_EXTENSION);
        boolean compress = "true".equalsIgnoreCase(this.getProperty("p2.compressed"));
        try {
            OutputStream output = null;
            if (!compress) {
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                output = new FileOutputStream(file);
            } else {
                if (file.exists()) {
                    file.delete();
                }
                if (!jarFile.exists()) {
                    if (!jarFile.getParentFile().exists()) {
                        jarFile.getParentFile().mkdirs();
                    }
                    jarFile.createNewFile();
                }
                JarEntry jarEntry = new JarEntry(file.getName());
                JarOutputStream jOutput = new JarOutputStream(new FileOutputStream(jarFile));
                jOutput.putNextEntry(jarEntry);
                output = jOutput;
            }
            super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()), (IProgressMonitor)new NullProgressMonitor());
            new MetadataRepositoryIO(this.getProvisioningAgent()).write((IMetadataRepository)this, output);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1003, new StringBuffer("Error saving metadata repository: ").append(this.getLocation()).toString(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String setProperty(String key, String newValue, IProgressMonitor monitor) {
        String string;
        try {
            String oldValue;
            block7: {
                oldValue = null;
                LocalMetadataRepository localMetadataRepository = this;
                // MONITORENTER : localMetadataRepository
                oldValue = super.setProperty(key, newValue, monitor);
                if (oldValue != newValue && (oldValue == null || !oldValue.equals(newValue))) break block7;
                String string2 = oldValue;
                // MONITOREXIT : localMetadataRepository
                Object var6_8 = null;
                if (monitor == null) return string2;
                monitor.done();
                return string2;
            }
            this.save();
            // MONITOREXIT : localMetadataRepository
            MetadataRepositoryManager manager = (MetadataRepositoryManager)((Object)this.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME));
            if (manager.removeRepository(this.getLocation())) {
                manager.addRepository((IMetadataRepository)this);
            }
            string = oldValue;
            Object var6_9 = null;
            if (monitor == null) return string;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return string;
    }

    /*
     * Exception decompiling
     */
    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 157->169)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void compress(IPool<IInstallableUnit> iuPool) {
        this.units.compress(iuPool);
    }
}

