/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.reconciler.dropins.DropinsRepositoryListener;
import org.eclipse.equinox.internal.p2.reconciler.dropins.PlatformXmlListener;
import org.eclipse.equinox.internal.p2.reconciler.dropins.ProfileSynchronizer;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.PathUtil;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    static final String PROP_APPLICATION_STATUS = "org.eclipse.equinox.p2.reconciler.application.status";
    public static final String ID = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String DROPINS_DIRECTORY = "org.eclipse.equinox.p2.reconciler.dropins.directory";
    private static final String DROPINS = "dropins";
    private static final String LINKS = "links";
    private static final String CONFIG_INI = "config.ini";
    private static final String PLATFORM_CFG = "org.eclipse.update/platform.xml";
    private static final String CACHE_FILENAME = "cache.timestamps";
    private static final String DIR_ECLIPSE = "eclipse";
    private static final String DIR_PLUGINS = "plugins";
    private static final String DIR_FEATURES = "features";
    private static final String EXT_LINK = ".link";
    public static final String TRACING_PREFIX = "[reconciler] ";
    private static BundleContext bundleContext;
    private static final Set<IMetadataRepository> repositories;
    private Collection<File> filesToCheck = null;

    static {
        repositories = new HashSet<IMetadataRepository>();
    }

    public static IMetadataRepository createExtensionLocationMetadataRepository(URI location, String name, Map<String, String> properties) throws ProvisionException {
        IProvisioningAgent agent = Activator.getAgent();
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        ExtensionLocationMetadataRepositoryFactory factory = new ExtensionLocationMetadataRepositoryFactory();
        factory.setAgent(agent);
        HashMap<String, String> repositoryProperties = new HashMap<String, String>();
        repositoryProperties.put("p2.compressed", Boolean.TRUE.toString());
        if (properties != null) {
            repositoryProperties.putAll(properties);
        }
        IMetadataRepository repository = factory.create(location, name, "org.eclipse.equinox.p2.extensionlocation.metadataRepository", repositoryProperties);
        ((MetadataRepositoryManager)manager).addRepository(repository);
        manager.setRepositoryProperty(location, "p2.system", String.valueOf(true));
        return repository;
    }

    private static IProvisioningAgent getAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
    }

    public static IMetadataRepository loadMetadataRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)Activator.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        IMetadataRepository repository = manager.loadRepository(location, monitor);
        manager.setRepositoryProperty(location, "p2.system", String.valueOf(true));
        return repository;
    }

    public static IArtifactRepository createExtensionLocationArtifactRepository(URI location, String name, Map<String, String> properties) throws ProvisionException {
        IProvisioningAgent agent = Activator.getAgent();
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        ExtensionLocationArtifactRepositoryFactory factory = new ExtensionLocationArtifactRepositoryFactory();
        factory.setAgent(agent);
        HashMap<String, String> repositoryProperties = new HashMap<String, String>();
        repositoryProperties.put("p2.compressed", Boolean.TRUE.toString());
        if (properties != null) {
            repositoryProperties.putAll(properties);
        }
        IArtifactRepository repository = factory.create(location, name, "org.eclipse.equinox.p2.extensionlocation.artifactRepository", repositoryProperties);
        ((ArtifactRepositoryManager)manager).addRepository(repository);
        manager.setRepositoryProperty(location, "p2.system", String.valueOf(true));
        return repository;
    }

    public static IArtifactRepository loadArtifactRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)Activator.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        IArtifactRepository repository = manager.loadRepository(location, monitor);
        manager.setRepositoryProperty(location, "p2.system", String.valueOf(true));
        return repository;
    }

    public static Set<IMetadataRepository> getRepositories() {
        return repositories;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        if (this.isUpToDate()) {
            this.filesToCheck = null;
            return;
        }
        this.checkConfigIni();
        this.watchDropins();
        this.watchConfiguration();
        Activator.synchronize(null);
        this.writeTimestamps();
        repositories.clear();
        this.filesToCheck = null;
    }

    /*
     * Exception decompiling
     */
    private void checkConfigIni() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 149->155)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isUpToDate() {
        if ("true".equals(Activator.getContext().getProperty("osgi.checkConfiguration"))) {
            Activator.trace("User requested forced reconciliation via \"osgi.checkConfiguration=true\" System property.");
            Activator.trace("Performing reconciliation.");
            return false;
        }
        Properties timestamps = this.readTimestamps();
        if (timestamps.isEmpty()) {
            Activator.trace("Cached timestamp file empty.");
            Activator.trace("Performing reconciliation.");
            return false;
        }
        Collection<File> files = this.getFilesToCheck();
        for (File file : files) {
            String key = file.getAbsolutePath();
            String timestamp = timestamps.getProperty(key);
            if (timestamp == null) {
                Activator.trace(new StringBuffer("Missing timestamp for file: ").append(key).toString());
                Activator.trace("Performing reconciliation.");
                return false;
            }
            long lastModified = file.lastModified();
            if (!Long.toString(lastModified).equals(timestamp)) {
                Activator.trace(new StringBuffer("Timestamp has been updated for file: ").append(key).append(", expected: ").append(timestamp).append(", actual: ").append(lastModified).toString());
                Activator.trace("Performing reconciliation.");
                return false;
            }
            timestamps.remove(key);
        }
        boolean result = timestamps.isEmpty();
        if (result) {
            Activator.trace("Cached timestamp values up to date.");
            Activator.trace("Reconciliation skipped.");
        } else if (Tracing.DEBUG_RECONCILER) {
            Activator.trace("Found extra values in cached timestamp file: ");
            Iterator<Object> iter = timestamps.keySet().iterator();
            while (iter.hasNext()) {
                Activator.trace(iter.next());
            }
            Activator.trace("Performing reconciliation. ");
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties readTimestamps() {
        Properties result = new Properties();
        File file = Activator.getContext().getDataFile(CACHE_FILENAME);
        if (!file.exists()) {
            return result;
        }
        Activator.trace(new StringBuffer("Reading timestamps from file: ").append(file.getAbsolutePath()).toString());
        BufferedInputStream input = null;
        try {
            try {
                input = new BufferedInputStream(new FileInputStream(file));
                result.load(input);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, ID, "Error occurred while reading cached timestamps for reconciliation.", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                if (input == null) throw throwable;
                ((InputStream)input).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (input != null) {
            ((InputStream)input).close();
        }
        if (!Tracing.DEBUG_RECONCILER) return result;
        Iterator<Object> iter = result.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = result.get(key);
            Activator.trace(new StringBuffer(String.valueOf(key.toString())).append('=').append(value).toString());
        }
        return result;
    }

    private Collection<File> getFilesToCheck() {
        File parentConfiguration;
        if (this.filesToCheck != null) {
            return this.filesToCheck;
        }
        HashSet<File> result = new HashSet<File>();
        File configuration = Activator.getConfigurationLocation();
        if (configuration != null) {
            result.add(new File(configuration, PLATFORM_CFG));
            File parent = configuration.getParentFile();
            if (parent != null) {
                File plugins = new File(parent, DIR_PLUGINS);
                result.add(plugins);
                File features = new File(parent, DIR_FEATURES);
                result.add(features);
            }
        }
        if ((parentConfiguration = Activator.getParentConfigurationLocation()) != null) {
            result.add(new File(parentConfiguration, PLATFORM_CFG));
            File parent = parentConfiguration.getParentFile();
            if (parent != null) {
                File plugins = new File(parent, DIR_PLUGINS);
                result.add(plugins);
                File features = new File(parent, DIR_FEATURES);
                result.add(features);
            }
        }
        File[] dropins = Activator.getDropinsDirectories();
        result.addAll(this.getDropinsToCheck(dropins));
        File[] links = Activator.getLinksDirectories();
        result.addAll(this.getDropinsToCheck(links));
        this.filesToCheck = result;
        return this.filesToCheck;
    }

    private Collection<File> getDropinsToCheck(File[] files) {
        HashSet<File> result = new HashSet<File>();
        int outer = 0;
        while (outer < files.length) {
            result.add(files[outer]);
            File[] children = files[outer].listFiles();
            int inner = 0;
            while (children != null && inner < children.length) {
                File child = children[inner];
                if (child.isFile() && child.getName().toLowerCase().endsWith(EXT_LINK)) {
                    DropinsRepositoryListener.LinkedRepository repo = DropinsRepositoryListener.getLinkedRepository(child);
                    if (repo != null && repo.exists()) {
                        File target = repo.getLocation();
                        result.add(child);
                        result.add(target);
                        File eclipse = new File(target, DIR_ECLIPSE);
                        result.add(eclipse);
                        result.add(new File(eclipse, DIR_PLUGINS));
                        result.add(new File(eclipse, DIR_FEATURES));
                    }
                } else if (child.getName().equalsIgnoreCase(DIR_ECLIPSE)) {
                    result.add(child);
                    result.add(new File(child, DIR_PLUGINS));
                    result.add(new File(child, DIR_FEATURES));
                } else if (child.isDirectory()) {
                    File features;
                    File parent;
                    result.add(child);
                    File eclipse = new File(child, DIR_ECLIPSE);
                    if (eclipse.exists()) {
                        result.add(eclipse);
                        parent = eclipse;
                    } else {
                        parent = child;
                    }
                    File plugins = new File(parent, DIR_PLUGINS);
                    if (plugins.exists()) {
                        result.add(plugins);
                    }
                    if ((features = new File(parent, DIR_FEATURES)).exists()) {
                        result.add(features);
                    }
                }
                ++inner;
            }
            ++outer;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private void writeTimestamps() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 257->261)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized void synchronize(IProgressMonitor monitor) {
        IProfile profile = Activator.getCurrentProfile(bundleContext);
        if (profile == null) {
            return;
        }
        ProfileSynchronizer synchronizer = new ProfileSynchronizer(Activator.getAgent(), profile, repositories);
        IStatus result = synchronizer.synchronize(monitor);
        if (ProfileSynchronizer.isReconciliationApplicationRunning()) {
            System.getProperties().put(PROP_APPLICATION_STATUS, result);
        }
        if (!result.isOK() && result.getSeverity() != 8) {
            LogHelper.log((IStatus)result);
        }
    }

    private void watchConfiguration() {
        File configFile = Activator.getConfigurationLocation();
        if (configFile == null) {
            LogHelper.log((IStatus)new Status(4, ID, "Unable to determine configuration location."));
            return;
        }
        if (!(configFile = new File(configFile, PLATFORM_CFG)).exists()) {
            File parentConfiguration = Activator.getParentConfigurationLocation();
            if (parentConfiguration == null) {
                return;
            }
            File shareConfigFile = new File(parentConfiguration, PLATFORM_CFG);
            if (!shareConfigFile.exists()) {
                return;
            }
            Configuration config = new Configuration();
            config.setDate(Long.toString(new Date().getTime()));
            config.setVersion("3.0");
            try {
                String sharedUR = PathUtil.makeRelative((String)shareConfigFile.toURL().toExternalForm(), (URL)Activator.getOSGiInstallArea()).replace('\\', '/');
                config.setSharedUR(sharedUR);
                configFile.getParentFile().mkdirs();
                config.save(configFile, Activator.getOSGiInstallArea());
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, ID, "Unable to create linked platform.xml.", (Throwable)e));
                return;
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, ID, "Unable to create linked platform.xml.", (Throwable)e));
                return;
            }
        }
        DirectoryWatcher watcher = new DirectoryWatcher(configFile.getParentFile());
        PlatformXmlListener listener = new PlatformXmlListener(configFile);
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        repositories.addAll(listener.getMetadataRepositories());
    }

    private void watchDropins() {
        ArrayList<File> directories = new ArrayList<File>();
        File[] dropinsDirectories = Activator.getDropinsDirectories();
        directories.addAll(Arrays.asList(dropinsDirectories));
        File[] linksDirectories = Activator.getLinksDirectories();
        directories.addAll(Arrays.asList(linksDirectories));
        if (directories.isEmpty()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", Boolean.TRUE.toString());
        properties.put("p2.system", Boolean.TRUE.toString());
        DropinsRepositoryListener listener = new DropinsRepositoryListener(Activator.getAgent(), DROPINS, properties);
        DirectoryWatcher watcher = new DirectoryWatcher(directories.toArray(new File[directories.size()]));
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        repositories.addAll(listener.getMetadataRepositories());
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    public static File getConfigurationLocation() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName(), (String)Location.CONFIGURATION_FILTER);
        if (configurationLocation == null || !configurationLocation.isSet()) {
            return null;
        }
        URL url = configurationLocation.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static File getParentConfigurationLocation() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName(), (String)Location.CONFIGURATION_FILTER);
        if (configurationLocation == null || !configurationLocation.isSet()) {
            return null;
        }
        Location sharedConfigurationLocation = configurationLocation.getParentLocation();
        if (sharedConfigurationLocation == null) {
            return null;
        }
        URL url = sharedConfigurationLocation.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static URL getOSGiInstallArea() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Location location = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        if (location == null) {
            return null;
        }
        if (!location.isSet()) {
            return null;
        }
        return location.getURL();
    }

    public static String substituteVariables(String path) {
        int endIndex;
        if (path == null) {
            return path;
        }
        int beginIndex = path.indexOf(37);
        if (beginIndex == -1) {
            return path;
        }
        if ((endIndex = path.indexOf(37, ++beginIndex)) == -1) {
            return path;
        }
        String var = path.substring(beginIndex, endIndex);
        if (var.length() == 0 || var.indexOf(File.pathSeparatorChar) != -1) {
            return path;
        }
        var = Activator.getContext().getProperty(var);
        if (var == null) {
            return path;
        }
        return new StringBuffer(String.valueOf(path.substring(0, beginIndex - 1))).append(var).append(path.substring(endIndex + 1)).toString();
    }

    public static File getEclipseHome() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Location eclipseHome = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName(), (String)Location.ECLIPSE_HOME_FILTER);
        if (eclipseHome == null || !eclipseHome.isSet()) {
            return null;
        }
        URL url = eclipseHome.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    private static File[] getLinksDirectories() {
        File configuration;
        ArrayList<File> linksDirectories = new ArrayList<File>();
        File root = Activator.getEclipseHome();
        if (root != null) {
            linksDirectories.add(new File(root, LINKS));
        }
        if (Activator.getParentConfigurationLocation() != null && (configuration = Activator.getConfigurationLocation()) != null && configuration.getParentFile() != null) {
            linksDirectories.add(new File(configuration.getParentFile(), LINKS));
        }
        return linksDirectories.toArray(new File[linksDirectories.size()]);
    }

    private static File[] getDropinsDirectories() {
        File configuration;
        File root;
        ArrayList<File> dropinsDirectories = new ArrayList<File>();
        String watchedDirectoryProperty = bundleContext.getProperty(DROPINS_DIRECTORY);
        if (watchedDirectoryProperty != null) {
            watchedDirectoryProperty = Activator.substituteVariables(watchedDirectoryProperty);
            dropinsDirectories.add(new File(watchedDirectoryProperty));
        }
        if ((root = Activator.getEclipseHome()) != null) {
            dropinsDirectories.add(new File(root, DROPINS));
        }
        if (Activator.getParentConfigurationLocation() != null && (configuration = Activator.getConfigurationLocation()) != null && configuration.getParentFile() != null) {
            dropinsDirectories.add(new File(configuration.getParentFile(), DROPINS));
        }
        return dropinsDirectories.toArray(new File[dropinsDirectories.size()]);
    }

    public static IProfile getCurrentProfile(BundleContext context) {
        IProvisioningAgent agent = Activator.getAgent();
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            return null;
        }
        return profileRegistry.getProfile("_SELF_");
    }

    public static void trace(Object message) {
        if (Tracing.DEBUG_RECONCILER) {
            Tracing.debug((String)new StringBuffer(TRACING_PREFIX).append(message).toString());
        }
    }
}

