/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class ArtifactRepositoryTracker
extends RepositoryTracker {
    ProvisioningUI ui;

    public ArtifactRepositoryTracker(ProvisioningUI ui) {
        this.ui = ui;
    }

    public URI[] getKnownRepositories(ProvisioningSession session) {
        return this.getArtifactRepositoryManager().getKnownRepositories(this.getArtifactRepositoryFlags());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRepository(URI repoLocation, String nickname, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            this.getArtifactRepositoryManager().addRepository(repoLocation);
            if (nickname != null) {
                this.getArtifactRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 1, 0, true), true);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 1, 0, true), true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            int i = 0;
            while (i < repoLocations.length) {
                this.getArtifactRepositoryManager().removeRepository(repoLocations[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.ui.signalRepositoryOperationComplete(null, true);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }

    public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
        this.ui.signalRepositoryOperationStart();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 100));
        int i = 0;
        while (i < locations.length) {
            try {
                this.getArtifactRepositoryManager().refreshRepository(locations[i], (IProgressMonitor)mon.newChild(100));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }

    IArtifactRepositoryManager getArtifactRepositoryManager() {
        return ProvUI.getArtifactRepositoryManager((ProvisioningSession)this.ui.getSession());
    }

    protected boolean contains(URI location, ProvisioningSession session) {
        return ProvUI.getArtifactRepositoryManager((ProvisioningSession)session).contains(location);
    }
}

