/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.interfaces.EntityLayout;

public class AlgorithmHelper {
    public static int MIN_NODE_SIZE = 8;
    public static double PADDING_PERCENT = 0.8;

    public static void fitWithinBounds(EntityLayout[] entities, Rectangle destinationBounds, boolean resize) {
        Rectangle startingBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        double sizeScale = Math.min(destinationBounds.getWidth() / startingBounds.getWidth(), destinationBounds.getHeight() / startingBounds.getHeight());
        if (entities.length == 1) {
            AlgorithmHelper.fitSingleEntity(entities[0], destinationBounds, resize);
            return;
        }
        int i = 0;
        while (i < entities.length) {
            EntityLayout entity = entities[i];
            Dimension size = entity.getSize();
            if (entity.isMovable()) {
                Point location = entity.getLocation();
                double percentX = (location.x - startingBounds.getX()) / startingBounds.getWidth();
                double percentY = (location.y - startingBounds.getY()) / startingBounds.getHeight();
                if (resize && entity.isResizable()) {
                    size.width *= sizeScale;
                    size.height *= sizeScale;
                    entity.setSize(size.width, size.height);
                }
                location.x = destinationBounds.getX() + size.width / 2.0 + percentX * (destinationBounds.getWidth() - size.width);
                location.y = destinationBounds.getY() + size.height / 2.0 + percentY * (destinationBounds.getHeight() - size.height);
                entity.setLocation(location.x, location.y);
            } else if (resize && entity.isResizable()) {
                entity.setSize(size.width * sizeScale, size.height * sizeScale);
            }
            ++i;
        }
    }

    private static void fitSingleEntity(EntityLayout entity, Rectangle destinationBounds, boolean resize) {
        if (entity.isMovable()) {
            entity.setLocation(destinationBounds.getX() + destinationBounds.getWidth() / 2.0, destinationBounds.getY() + destinationBounds.getHeight() / 2.0);
        }
        if (resize && entity.isResizable()) {
            double width = destinationBounds.getWidth();
            double height = destinationBounds.getHeight();
            double preferredAspectRatio = entity.getPreferredAspectRatio();
            if (preferredAspectRatio > 0.0) {
                Dimension fixedSize = AlgorithmHelper.fixAspectRatio(width, height, preferredAspectRatio);
                entity.setSize(fixedSize.width, fixedSize.height);
            } else {
                entity.setSize(width, height);
            }
        }
    }

    public static void maximizeSizes(EntityLayout[] entities) {
        if (entities.length > 1) {
            double nodeSize;
            Dimension minDistance = AlgorithmHelper.getMinimumDistance(entities);
            double width = nodeSize = Math.max(minDistance.width, minDistance.height) * PADDING_PERCENT;
            double height = nodeSize;
            int i = 0;
            while (i < entities.length) {
                EntityLayout entity = entities[i];
                if (entity.isResizable()) {
                    double preferredRatio = entity.getPreferredAspectRatio();
                    if (preferredRatio > 0.0) {
                        Dimension fixedSize = AlgorithmHelper.fixAspectRatio(width, height, preferredRatio);
                        entity.setSize(fixedSize.width, fixedSize.height);
                    } else {
                        entity.setSize(width, height);
                    }
                }
                ++i;
            }
        }
    }

    private static Dimension fixAspectRatio(double width, double height, double preferredRatio) {
        double actualRatio = width / height;
        if (actualRatio > preferredRatio && (width = height * preferredRatio) < (double)MIN_NODE_SIZE) {
            width = MIN_NODE_SIZE;
            height = width / preferredRatio;
        }
        if (actualRatio < preferredRatio && (height = width / preferredRatio) < (double)MIN_NODE_SIZE) {
            height = MIN_NODE_SIZE;
            width = height * preferredRatio;
        }
        return new Dimension(width, height);
    }

    public static Rectangle getLayoutBounds(EntityLayout[] entities, boolean includeNodeSize) {
        double rightSide = Double.NEGATIVE_INFINITY;
        double bottomSide = Double.NEGATIVE_INFINITY;
        double leftSide = Double.POSITIVE_INFINITY;
        double topSide = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < entities.length) {
            EntityLayout entity = entities[i];
            Point location = entity.getLocation();
            Dimension size = entity.getSize();
            if (includeNodeSize) {
                leftSide = Math.min(location.x - size.width / 2.0, leftSide);
                topSide = Math.min(location.y - size.height / 2.0, topSide);
                rightSide = Math.max(location.x + size.width / 2.0, rightSide);
                bottomSide = Math.max(location.y + size.height / 2.0, bottomSide);
            } else {
                leftSide = Math.min(location.x, leftSide);
                topSide = Math.min(location.y, topSide);
                rightSide = Math.max(location.x, rightSide);
                bottomSide = Math.max(location.y, bottomSide);
            }
            ++i;
        }
        return new Rectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
    }

    public static Dimension getMinimumDistance(EntityLayout[] entities) {
        Dimension horAndVertdistance = new Dimension(Double.MAX_VALUE, Double.MAX_VALUE);
        double minDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < entities.length) {
            Point location1 = entities[i].getLocation();
            int j = i + 1;
            while (j < entities.length) {
                Point location2 = entities[j].getLocation();
                double distanceX = location1.x - location2.x;
                double distanceY = location1.y - location2.y;
                double distance = distanceX * distanceX + distanceY * distanceY;
                if (distance < minDistance) {
                    minDistance = distance;
                    horAndVertdistance.width = Math.abs(distanceX);
                    horAndVertdistance.height = Math.abs(distanceY);
                }
                ++j;
            }
            ++i;
        }
        return horAndVertdistance;
    }
}

