/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.interfaces.ConnectionLayout;
import org.eclipse.gef4.layout.interfaces.LayerProvider;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFSLayerProvider
implements LayerProvider {
    private Map<NodeLayout, Integer> assignedNodes = new IdentityHashMap<NodeLayout, Integer>();
    private ArrayList<NodeLayout> openedList = new ArrayList();
    private ArrayList<NodeLayout> closedList = new ArrayList();
    private ArrayList<NodeLayout> initClosedList = new ArrayList();
    private final List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
    private final Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();

    private List<ConnectionLayout> intersectOfConnections(ConnectionLayout[] a, ConnectionLayout[] b) {
        ArrayList<ConnectionLayout> res = new ArrayList<ConnectionLayout>();
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                if (a[i].equals(b[j])) {
                    res.add(a[i]);
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private void addToInitClosedList(NodeLayout node, int layout) {
        NodeWrapper nw = new NodeWrapper(node, layout);
        this.map.put(node, nw);
        this.initClosedList.add(node);
    }

    public ArrayList<NodeLayout> getRoots(List<NodeLayout> nodes) {
        ArrayList<NodeLayout> res = new ArrayList<NodeLayout>();
        for (NodeLayout node : nodes) {
            if (node.getIncomingConnections().length == 0) {
                res.add(node);
                continue;
            }
            int sizeOfIntersect = this.intersectOfConnections(node.getIncomingConnections(), node.getOutgoingConnections()).size();
            if (node.getOutgoingConnections().length > sizeOfIntersect) {
                res.add(node);
            }
            if (node.getIncomingConnections().length != sizeOfIntersect || node.getOutgoingConnections().length != sizeOfIntersect) continue;
            res.add(node);
        }
        if (res.size() == 0) {
            res.add(nodes.get(0));
        }
        return res;
    }

    @Override
    public Map<NodeLayout, Integer> getAssignedNodes() {
        return this.assignedNodes;
    }

    @Override
    public void addAssignedNode(NodeLayout node, int layer) {
        this.assignedNodes.put(node, layer);
    }

    @Override
    public void clearAssignedNodes() {
        this.assignedNodes.clear();
    }

    private static void updateIndex(List<NodeWrapper> list) {
        int index = 0;
        while (index < list.size()) {
            list.get((int)index).index = index;
            ++index;
        }
    }

    private void addLayer(List<NodeLayout> list) {
        ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
        for (NodeLayout node : list) {
            NodeWrapper nw = new NodeWrapper(node, this.layers.size());
            this.map.put(node, nw);
            layer.add(nw);
        }
        this.layers.add(layer);
        DFSLayerProvider.updateIndex(layer);
    }

    private ArrayList<NodeLayout> Unfold(NodeLayout toUnfold) {
        NodeLayout endPoint;
        ArrayList<NodeLayout> res = new ArrayList<NodeLayout>();
        int i = 0;
        while (i < toUnfold.getOutgoingConnections().length) {
            endPoint = toUnfold.getOutgoingConnections()[i].getTarget();
            if (endPoint.equals(toUnfold)) {
                endPoint = toUnfold.getOutgoingConnections()[i].getSource();
            }
            if (!(this.closedList.contains(endPoint) || this.openedList.contains(endPoint) || res.contains(endPoint))) {
                res.add(endPoint);
            }
            ++i;
        }
        i = 0;
        while (i < toUnfold.getIncomingConnections().length) {
            endPoint = toUnfold.getIncomingConnections()[i].getTarget();
            if (endPoint.equals(toUnfold)) {
                endPoint = toUnfold.getIncomingConnections()[i].getSource();
            }
            if (!(this.closedList.contains(endPoint) || this.openedList.contains(endPoint) || res.contains(endPoint))) {
                res.add(endPoint);
            }
            ++i;
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<List<NodeWrapper>> calculateLayers(List<NodeLayout> nodes, Map<NodeLayout, Integer> assignedNodes) {
        block16: {
            this.openedList.clear();
            this.initClosedList.clear();
            this.closedList.clear();
            this.layers.clear();
            this.map.clear();
            if (assignedNodes != null) {
                for (NodeLayout node : nodes) {
                    if (!assignedNodes.containsKey(node)) continue;
                    this.addToInitClosedList(node, assignedNodes.get(node));
                }
            }
            if (this.initClosedList.size() <= 0) break block16;
            this.closedList.addAll(this.initClosedList);
            nodes.removeAll(this.initClosedList);
            this.initClosedList.clear();
            for (NodeLayout node : this.closedList) {
                if (this.map.get((Object)node).layer >= this.layers.size()) ** GOTO lbl25
                this.layers.get(this.map.get((Object)node).layer).add(this.map.get(node));
                DFSLayerProvider.updateIndex(this.layers.get(this.map.get((Object)node).layer));
                continue;
lbl-1000:
                // 1 sources

                {
                    layer = new ArrayList<NodeLayout>();
                    this.addLayer(layer);
lbl25:
                    // 2 sources

                    ** while (this.map.get((Object)node).layer != this.layers.size())
                }
lbl26:
                // 1 sources

                layer = new ArrayList<E>();
                layer.add(node);
                this.addLayer(layer);
            }
        }
        startPoints = new ArrayList<NodeLayout>();
        if (nodes.size() > 0) {
            if (this.layers.size() > 0 && this.layers.get(0).size() > 0) {
                startPoints.add(this.layers.get((int)0).get((int)0).node);
            } else if (this.layers.size() == 0) {
                startPoints.add(this.getRoots(nodes).get(0));
                this.addLayer(startPoints);
            } else {
                startPoints.add(this.getRoots(nodes).get(0));
                for (NodeLayout startPoint : startPoints) {
                    if (this.map.containsKey(startPoint)) continue;
                    nw = new NodeWrapper(startPoint, 0);
                    this.map.put(startPoint, nw);
                    this.layers.get(0).add(nw);
                }
                DFSLayerProvider.updateIndex(this.layers.get(0));
            }
            this.openedList.addAll(startPoints);
            toUnfold = startPoints.get(0);
            while (this.openedList.size() != 0) {
                unfolded = this.Unfold(toUnfold);
                if (unfolded.size() > 0) {
                    level = this.map.get((Object)toUnfold).layer + 1;
                    if (level < this.layers.size()) {
                        for (NodeLayout n : unfolded) {
                            if (this.map.containsKey(n)) continue;
                            nw = new NodeWrapper(n, level);
                            this.map.put(n, nw);
                            this.layers.get(level).add(nw);
                        }
                        DFSLayerProvider.updateIndex(this.layers.get(level));
                    } else {
                        layer = new ArrayList<NodeLayout>();
                        layer.addAll(unfolded);
                        this.addLayer(layer);
                    }
                    this.openedList.addAll(0, unfolded);
                }
                this.closedList.add(toUnfold);
                this.openedList.remove(toUnfold);
                nodes.remove(toUnfold);
                if (this.openedList.size() == 0) continue;
                toUnfold = this.openedList.get(0);
            }
            if (nodes.size() > 0) {
                this.calculateLayers(nodes, null);
            }
        }
        return this.layers;
    }
}

