/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeWrapper {
    int index;
    final int layer;
    final NodeLayout node;
    final List<NodeWrapper> pred = new LinkedList<NodeWrapper>();
    final List<NodeWrapper> succ = new LinkedList<NodeWrapper>();
    private static final int PADDING = -1;

    NodeWrapper(NodeLayout n, int l) {
        this.node = n;
        this.layer = l;
    }

    NodeWrapper(int l) {
        this(null, l);
    }

    NodeWrapper() {
        this(null, -1);
    }

    void addPredecessor(NodeWrapper node) {
        this.pred.add(node);
    }

    void addSuccessor(NodeWrapper node) {
        this.succ.add(node);
    }

    boolean isDummy() {
        return this.node == null && this.layer != -1;
    }

    boolean isPadding() {
        return this.node == null && this.layer == -1;
    }

    int getBaryCenter(List<NodeWrapper> list) {
        if (list.isEmpty()) {
            return this.index;
        }
        if (list.size() == 1) {
            return list.get((int)0).index;
        }
        double barycenter = 0.0;
        for (NodeWrapper node : list) {
            barycenter += (double)node.index;
        }
        return (int)(barycenter / (double)list.size());
    }

    int getPriorityDown() {
        if (this.isPadding()) {
            return 0;
        }
        if (this.isDummy() && this.succ != null && this.succ.size() > 0) {
            if (this.succ.get(0).isDummy()) {
                return Integer.MAX_VALUE;
            }
            return 0x3FFFFFFF;
        }
        return this.pred.size();
    }

    int getPriorityUp() {
        if (this.isPadding()) {
            return 0;
        }
        if (this.isDummy() && this.pred != null && this.pred.size() > 0) {
            if (this.pred.get(0).isDummy()) {
                return Integer.MAX_VALUE;
            }
            return 0x3FFFFFFF;
        }
        return this.succ.size();
    }
}

