/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.awt;

import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.RoundedRectangle;

public class Geometry2AWT {
    public static java.awt.geom.AffineTransform toAWTAffineTransform(AffineTransform t) {
        double[] matrix = t.getMatrix();
        return new java.awt.geom.AffineTransform(Arrays.copyOf(matrix, matrix.length));
    }

    public static Line2D.Double toAWTLine(Line l) {
        return new Line2D.Double(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public static Path2D.Double toAWTPath(Path p) {
        Path2D.Double path = new Path2D.Double(p.getWindingRule() == 0 ? 0 : 1);
        Path.Segment[] segmentArray = p.getSegments();
        int n = segmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path.Segment s = segmentArray[n2];
            Point[] points = s.getPoints();
            switch (s.getType()) {
                case 0: {
                    path.moveTo(points[0].x, points[0].y);
                    break;
                }
                case 1: {
                    path.lineTo(points[0].x, points[0].y);
                    break;
                }
                case 2: {
                    path.quadTo(points[0].x, points[0].y, points[1].x, points[1].y);
                    break;
                }
                case 3: {
                    path.curveTo(points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
            }
            ++n2;
        }
        return path;
    }

    public static final Point2D.Double toAWTPoint(Point p) {
        return new Point2D.Double(p.x, p.y);
    }

    public static Point2D.Double[] toAWTPoints(Point[] pts) {
        Point2D.Double[] points = new Point2D.Double[pts.length];
        int i = 0;
        while (i < pts.length) {
            points[i] = Geometry2AWT.toAWTPoint(pts[i]);
            ++i;
        }
        return points;
    }

    public static final Rectangle2D.Double toAWTRectangle(Rectangle r) {
        return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static RoundRectangle2D.Double toAWTRoundRectangle(RoundedRectangle r) {
        return new RoundRectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight(), r.getArcWidth(), r.getArcHeight());
    }

    private Geometry2AWT() {
    }
}

