/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.interfaces.ConnectionLayout;
import org.eclipse.gef4.layout.interfaces.LayerProvider;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFSLayerProvider
implements LayerProvider {
    private Map<NodeLayout, Integer> assignedNodes = new IdentityHashMap<NodeLayout, Integer>();

    private List<ConnectionLayout> intersectOfConnections(ConnectionLayout[] a, ConnectionLayout[] b) {
        ArrayList<ConnectionLayout> res = new ArrayList<ConnectionLayout>();
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                if (a[i].equals(b[j])) {
                    res.add(a[i]);
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private void addToInitClosedList(NodeLayout node, int layout, List<NodeLayout> initClosedList, Map<NodeLayout, NodeWrapper> map) {
        NodeWrapper nw = new NodeWrapper(node, layout);
        map.put(node, nw);
        initClosedList.add(node);
    }

    public ArrayList<NodeLayout> getRoots(List<NodeLayout> nodes) {
        ArrayList<NodeLayout> res = new ArrayList<NodeLayout>();
        for (NodeLayout node : nodes) {
            if (node.getIncomingConnections().length == 0) {
                res.add(node);
                continue;
            }
            int sizeOfIntersect = this.intersectOfConnections(node.getIncomingConnections(), node.getOutgoingConnections()).size();
            if (node.getOutgoingConnections().length > sizeOfIntersect) {
                res.add(node);
            }
            if (node.getIncomingConnections().length != sizeOfIntersect || node.getOutgoingConnections().length != sizeOfIntersect) continue;
            res.add(node);
        }
        if (res.size() == 0) {
            res.add(nodes.get(0));
        }
        return res;
    }

    public Map<NodeLayout, Integer> getAssignedNodes() {
        return this.assignedNodes;
    }

    public void addAssignedNode(NodeLayout node, int layer) {
        this.assignedNodes.put(node, layer);
    }

    public void clearAssignedNodes() {
        this.assignedNodes.clear();
    }

    private static void updateIndex(List<NodeWrapper> list) {
        int index = 0;
        while (index < list.size()) {
            list.get((int)index).index = index;
            ++index;
        }
    }

    private void addLayer(List<NodeLayout> list, List<List<NodeWrapper>> layers, Map<NodeLayout, NodeWrapper> map) {
        ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
        for (NodeLayout node : list) {
            NodeWrapper nw = new NodeWrapper(node, layers.size());
            map.put(node, nw);
            layer.add(nw);
        }
        layers.add(layer);
        DFSLayerProvider.updateIndex(layer);
    }

    private ArrayList<NodeLayout> Unfold(NodeLayout toUnfold, Set<NodeLayout> openedList, Set<NodeLayout> closedList) {
        NodeLayout endPoint;
        ArrayList<NodeLayout> res = new ArrayList<NodeLayout>();
        int i = 0;
        while (i < toUnfold.getOutgoingConnections().length) {
            endPoint = toUnfold.getOutgoingConnections()[i].getTarget();
            if (endPoint.equals(toUnfold)) {
                endPoint = toUnfold.getOutgoingConnections()[i].getSource();
            }
            if (!(closedList.contains(endPoint) || openedList.contains(endPoint) || res.contains(endPoint))) {
                res.add(endPoint);
            }
            ++i;
        }
        i = 0;
        while (i < toUnfold.getIncomingConnections().length) {
            endPoint = toUnfold.getIncomingConnections()[i].getTarget();
            if (endPoint.equals(toUnfold)) {
                endPoint = toUnfold.getIncomingConnections()[i].getSource();
            }
            if (!(closedList.contains(endPoint) || openedList.contains(endPoint) || res.contains(endPoint))) {
                res.add(endPoint);
            }
            ++i;
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<List<NodeWrapper>> calculateLayers(List<NodeLayout> nodeLayouts) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

