/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.generator.model.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.viatra.query.tooling.generator.model.generatorModel.GeneratorModelReference;
import org.eclipse.viatra.query.tooling.generator.model.validation.GeneratorModelJavaValidator;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.validation.Check;

public class GenmodelProjectBasedValidation
extends GeneratorModelJavaValidator {
    public static final String GENMODEL_DEPENDENCY = "org.eclipse.viatra.query.tooling.generator.model.ui.genmodel_dependency";
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private Logger logger;

    @Check
    public void checkGenmodelDependencies(GeneratorModelReference ref) {
        Resource res = ref.eResource();
        if (res != null && this.projectProvider != null) {
            IProject project = this.projectProvider.getJavaProject(res.getResourceSet()).getProject();
            GenModel genmodel = ref.getGenmodel();
            if (genmodel != null) {
                this.checkExistingDependency(ref, project, genmodel);
            }
        }
    }

    private void checkExistingDependency(GeneratorModelReference ref, IProject project, GenModel genmodel) {
        String modelPluginID = genmodel.getModelPluginID();
        try {
            if (modelPluginID != null && !modelPluginID.isEmpty() && !ProjectGenerationHelper.checkBundleDependency((IProject)project, (String)modelPluginID)) {
                this.error(String.format("To refer elements from the Generator Model %s the bundle %s must be added as dependency", genmodel.eResource().getURI().toString(), modelPluginID), (EObject)ref, null, GENMODEL_DEPENDENCY, new String[]{modelPluginID});
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error checking project: ", (Throwable)e);
        }
    }
}

