/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.maven.plugin.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MavenVersionNumberConverter {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(\\.\\d+)?(\\.\\d+)?([\\.-]{1}.*)?");

    public String convertToOsgi(String mavenVersionNumber) {
        VersionBuilder versionBuilder = new VersionBuilder();
        Matcher matcher = VERSION_PATTERN.matcher(mavenVersionNumber);
        matcher.find();
        versionBuilder.setMajor(matcher.group(1));
        versionBuilder.setMinor(matcher.group(2));
        versionBuilder.setMicro(matcher.group(3));
        versionBuilder.setQualifier(matcher.group(4));
        return versionBuilder.getVersionString();
    }

    private static class VersionBuilder {
        private volatile String major = "0";
        private volatile String minor = "0";
        private volatile String micro = "0";
        private volatile String qualifier = null;

        private VersionBuilder() {
        }

        public void setMajor(String major) {
            if (major != null) {
                this.major = major;
            }
        }

        public void setMinor(String minor) {
            if (minor != null) {
                this.minor = this.trim(minor);
            }
        }

        public void setMicro(String micro) {
            if (micro != null) {
                this.micro = this.trim(micro);
            }
        }

        public void setQualifier(String qualifier) {
            if (qualifier != null) {
                this.qualifier = this.trim(qualifier).replaceAll("\\.", "_");
            }
        }

        public String getVersionString() {
            if (this.qualifier == null) {
                return String.format("%s.%s.%s", this.major, this.minor, this.micro);
            }
            return String.format("%s.%s.%s.%s", this.major, this.minor, this.micro, this.qualifier);
        }

        private String trim(String s) {
            return s.substring(1);
        }
    }
}

