/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.export;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.jarpackager.IJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.virgo.ide.export.BundleExportUtils;
import org.eclipse.virgo.ide.export.ParExportWizardPage;
import org.eclipse.virgo.ide.export.ServerExportPlugin;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

public class ParExportWizard
extends Wizard
implements IExportWizard {
    private ParExportWizardPage wizardPage;
    private IStructuredSelection selection;
    private static final String TITLE = "Par Export Wizard";
    private static final String PAR_FILE_NAME = ".settings/org.eclipse.virgo.ide.runtime.core.par.xml";

    public void addPages() {
        this.wizardPage = new ParExportWizardPage(this.selection);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        boolean overwrite;
        IProject project = this.wizardPage.getSelectedProject();
        IPath jarLocation = this.wizardPage.getJarLocation();
        if (jarLocation.toFile().exists() && !this.wizardPage.getOverwrite() && !(overwrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite File", (String)("The file " + jarLocation.toOSString() + " already exists. Do you want to overwrite the existing file?")))) {
            return false;
        }
        return ParExportWizard.exportPar(project, jarLocation, (IRunnableContext)this.getContainer(), this.getShell());
    }

    public static boolean exportPar(IProject project, IPath parLocation, IRunnableContext context, Shell shell) {
        IFile parFile = project.getFile(PAR_FILE_NAME);
        IFolder settingsFolder = project.getFolder(".settings");
        IPath settingsPath = settingsFolder.getLocation();
        ArrayList<IStatus> warnings = new ArrayList<IStatus>();
        URI fileURI = URI.createPlatformResourceURI((String)parFile.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(fileURI, true);
        EList contents = resource.getContents();
        HashSet<IFile> parElements = new HashSet<IFile>();
        for (EObject content : contents) {
            if (!(content instanceof Par)) continue;
            Par par = (Par)content;
            EList bundles = par.getBundle();
            for (Bundle bundle : bundles) {
                IPath jarPath;
                String bundleName = bundle.getSymbolicName();
                IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
                BundleManifest manifest = BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(JavaCore.create((IProject)bundleProject));
                String jarName = null;
                if (manifest != null && manifest.getBundleVersion() != null && manifest.getBundleSymbolicName() != null) {
                    String version = manifest.getBundleVersion().toString();
                    String name = manifest.getBundleSymbolicName() != null && manifest.getBundleSymbolicName().getSymbolicName() != null ? manifest.getBundleSymbolicName().getSymbolicName() : bundleProject.getName();
                    jarName = String.valueOf(name) + "-" + version;
                } else {
                    jarName = bundleProject.getProject().toString();
                }
                if (FacetUtils.hasProjectFacet((IResource)bundleProject, (String)"jst.web")) {
                    IFile bundleJar;
                    if (!BundleExportUtils.executeWarExportOperation(bundleProject, jarName = String.valueOf(jarName) + ".war", settingsFolder) || !(bundleJar = settingsFolder.getFile(jarName)).exists()) continue;
                    parElements.add(bundleJar);
                    continue;
                }
                IJavaProject javaBundleProject = JavaCore.create((IProject)bundleProject);
                IJarExportRunnable op = BundleExportUtils.createExportOperation(javaBundleProject, jarPath = settingsPath.append(jarName = String.valueOf(jarName) + ".jar"), shell, warnings);
                if (!BundleExportUtils.executeExportOperation(op, false, context, shell, warnings)) continue;
                IFile bundleJar = settingsFolder.getFile(jarName);
                parElements.add(bundleJar);
            }
        }
        HashSet<Object> jarElements = new HashSet<Object>();
        jarElements.addAll(parElements);
        try {
            IResource[] rootMembers = project.members();
            IResource[] iResourceArray = rootMembers;
            int n = rootMembers.length;
            int bundles = 0;
            while (bundles < n) {
                Object rootMember = iResourceArray[bundles];
                String fileExtension = rootMember.getFileExtension();
                if (fileExtension != null && fileExtension.equals("jar")) {
                    jarElements.add(rootMember);
                }
                ++bundles;
            }
        }
        catch (CoreException coreException) {}
        JarPackageData parPackage = new JarPackageData();
        parPackage.setJarLocation(parLocation);
        parPackage.setExportClassFiles(true);
        parPackage.setExportOutputFolders(false);
        parPackage.setExportJavaFiles(false);
        parPackage.setElements(jarElements.toArray());
        parPackage.setOverwrite(true);
        IPath manifestPath = ParExportWizard.locateManifestFile(project);
        if (manifestPath != null) {
            parPackage.setGenerateManifest(false);
            parPackage.setManifestLocation(manifestPath);
        } else {
            parPackage.setGenerateManifest(true);
        }
        IJarBuilder builder = parPackage.getJarBuilder();
        try {
            builder.open(parPackage, shell, null);
            for (IResource iResource : jarElements) {
                if (!(iResource instanceof IFile)) continue;
                try {
                    builder.writeFile((IFile)iResource, (IPath)new Path(iResource.getName()));
                }
                catch (CoreException coreException) {}
            }
            builder.close();
        }
        catch (CoreException coreException) {}
        for (IResource iResource : parElements) {
            try {
                iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        if (warnings.size() > 0) {
            ErrorDialog.openError((Shell)shell, (String)"PAR export warnings", null, (IStatus)new MultiStatus("org.eclipse.virgo.ide.export", 2, warnings.toArray(new IStatus[0]), "There were warnings while export the PAR project. Click Details to see more...", null));
        }
        return true;
    }

    private static IPath locateManifestFile(IProject project) {
        Path path = new Path("META-INF/MANIFEST.MF");
        IResource manifestFile = project.findMember((IPath)path);
        if (manifestFile != null) {
            return new Path(project.getName()).append((IPath)path);
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(ServerExportPlugin.getImageDescriptor("full/wizban/wizban-par.png"));
    }
}

