/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainerUpdateJob;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestManager;

public class RefreshServerClasspathContainerActionDelegate
implements IObjectActionDelegate {
    private final List<IProject> selected = new ArrayList<IProject>();

    public void run(IAction action) {
        LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        for (IProject project : this.selected) {
            if (FacetUtils.isBundleProject((IResource)project)) {
                projects.add(JavaCore.create((IProject)project));
                continue;
            }
            if (!FacetUtils.isParProject((IResource)project)) continue;
            IProject[] iProjectArray = FacetUtils.getBundleProjects((IProject)project);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject bundle = iProjectArray[n2];
                projects.add(JavaCore.create((IProject)bundle));
                ++n2;
            }
        }
        for (IJavaProject javaProject : projects) {
            ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob((IJavaProject)javaProject, (Set)BundleManifestManager.IMPORTS_CHANGED);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

