/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

final class WebContainerUtils {
    private static final String WAR_HEADER = "org-eclipse-virgo-web-war-detected";
    private static final String DEFAULTED_BSN = "org-eclipse-virgo-kernel-DefaultedBSN";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    WebContainerUtils() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static boolean isWebApplicationBundle(BundleManifest manifest) {
        try {
            return !WebContainerUtils.isWar(manifest) && (WebContainerUtils.specifiesBundleSymbolicName(manifest) || WebContainerUtils.specifiesBundleVersion(manifest) || WebContainerUtils.specifiesBundleManifestVersion(manifest) || WebContainerUtils.specifiesImportPackage(manifest) || WebContainerUtils.specifiesWebContextPath(manifest));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isWar(BundleManifest manifest) {
        try {
            return manifest.getHeader(WAR_HEADER) != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesBundleSymbolicName(BundleManifest manifest) {
        try {
            if (manifest.getHeader(DEFAULTED_BSN) != null) {
                return false;
            }
            return manifest.getBundleSymbolicName().getSymbolicName() != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesBundleVersion(BundleManifest manifest) {
        try {
            return manifest.getHeader("Bundle-Version") != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesBundleManifestVersion(BundleManifest manifest) {
        try {
            return manifest.getBundleManifestVersion() != 1;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesImportPackage(BundleManifest manifest) {
        try {
            return !manifest.getImportPackage().getImportedPackages().isEmpty();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean specifiesWebContextPath(BundleManifest manifest) {
        try {
            return manifest.getHeader("Web-ContextPath") != null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WebContainerUtils");
    }
}

