/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import javax.net.SocketFactory;
import org.eclipse.jetty.client.AbstractHttpConnection;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.BlockingHttpConnection;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

class SocketConnector
extends AbstractLifeCycle
implements HttpClient.Connector {
    private static final Logger LOG = Log.getLogger(SocketConnector.class);
    private final HttpClient _httpClient;

    SocketConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    @Override
    public void startConnection(final HttpDestination destination) throws IOException {
        Socket socket = destination.isSecure() ? this._httpClient.getSslContextFactory().newSslSocket() : SocketFactory.getDefault().createSocket();
        socket.setSoTimeout(0);
        socket.setTcpNoDelay(true);
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        socket.connect(address.toSocketAddress(), this._httpClient.getConnectTimeout());
        SocketEndPoint endpoint = new SocketEndPoint(socket);
        final BlockingHttpConnection connection = new BlockingHttpConnection(this._httpClient.getRequestBuffers(), this._httpClient.getResponseBuffers(), (EndPoint)endpoint);
        connection.setDestination(destination);
        destination.onNewConnection(connection);
        this._httpClient.getThreadPool().dispatch(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection next;
                    AbstractHttpConnection con = connection;
                    while ((next = con.handle()) != con) {
                        con = next;
                    }
                }
                catch (IOException e) {
                    if (e instanceof InterruptedIOException) {
                        LOG.ignore((Throwable)e);
                    } else {
                        LOG.debug((Throwable)e);
                        destination.onException(e);
                    }
                }
                finally {
                    try {
                        destination.returnConnection(connection, true);
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
        });
    }
}

