/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class JaxRpcServiceReference
extends Reference {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, JaxRpcServiceReference.class);
    private String serviceClassName;
    private ClassLoader classLoader;
    private URI wsdlURI;
    private QName serviceQName;
    private String referenceClassName;

    public JaxRpcServiceReference(QName serviceQName, URI wsdlURI, String referenceClassName, String serviceClassName, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.serviceQName = serviceQName;
        this.wsdlURI = wsdlURI;
        this.referenceClassName = referenceClassName;
        this.serviceClassName = serviceClassName;
    }

    @Override
    public Object getObject() throws NamingException {
        Class<Service> serviceClass = this.loadClass(this.serviceClassName).asSubclass(Service.class);
        Class referenceClass = this.getReferenceClass();
        if (referenceClass != null && Service.class.isAssignableFrom(referenceClass)) {
            serviceClass = referenceClass.asSubclass(Service.class);
        }
        try {
            Service instance;
            if (Service.class.equals(serviceClass)) {
                instance = ServiceFactory.newInstance().createService(this.getWsdlURL(), this.serviceQName);
            } else {
                try {
                    instance = serviceClass.getConstructor(URL.class, QName.class).newInstance(this.getWsdlURL(), this.serviceQName);
                }
                catch (Throwable e) {
                    throw (NamingException)new NamingException("Could not instantiate jax-ws service class " + serviceClass.getName()).initCause(e);
                }
            }
            if (referenceClass != null && !Service.class.isAssignableFrom(referenceClass)) {
                return instance.getPort(referenceClass);
            }
            return instance;
        }
        catch (ServiceException e) {
            throw (NamingException)new NamingException("Error creating service proxy").initCause(e);
        }
    }

    private Class getReferenceClass() throws NamingException {
        if (this.referenceClassName == null) {
            return null;
        }
        return this.loadClass(this.referenceClassName);
    }

    private Class<?> loadClass(String name) throws NamingException {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            NamingException exception = new NamingException("Count not load class " + name);
            exception.initCause(e);
            throw exception;
        }
    }

    private URL getWsdlURL() {
        if (this.wsdlURI == null) {
            return null;
        }
        try {
            return new URL(this.wsdlURI.toString());
        }
        catch (MalformedURLException e) {
            URL wsdlURL = this.classLoader.getResource(this.wsdlURI.toString());
            if (wsdlURL == null) {
                logger.warning("Error obtaining WSDL: " + this.wsdlURI, e);
            }
            return wsdlURL;
        }
    }
}

