/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.war.deployer;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class IOUtils {
    private static final char SEPARATOR1 = '/';
    private static final char SEPARATOR2 = '\\';

    public static boolean recursiveDelete(File root) {
        File[] files;
        if (root == null) {
            return true;
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    IOUtils.recursiveDelete(file);
                } else {
                    file.delete();
                }
                ++i;
            }
        }
        return root.delete();
    }

    public static void extractJar(File srcFile, File destDir) throws IOException {
        if (srcFile == null) {
            throw new IllegalArgumentException("Source file is null.");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("Destination directory is null.");
        }
        if (!srcFile.isFile() || !srcFile.canRead()) {
            throw new IllegalArgumentException("Source file must be a readable file [" + srcFile + "].");
        }
        if (destDir.exists()) {
            IOUtils.recursiveDelete(destDir);
        }
        destDir.mkdirs();
        if (!destDir.exists()) {
            throw new IOException("Could not create destination directory [" + destDir + "].");
        }
        JarFile zip = new JarFile(srcFile);
        try {
            Enumeration<JarEntry> enumZipEntries = zip.entries();
            String entryName = null;
            JarEntry theEntry = null;
            while (enumZipEntries.hasMoreElements()) {
                theEntry = enumZipEntries.nextElement();
                entryName = theEntry.getName();
                if (entryName == null) continue;
                IOUtils.extractFile(zip, entryName, destDir);
            }
        }
        catch (Throwable throwable) {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (zip != null) {
            try {
                zip.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void extractFile(JarFile zipf, String entryName, File dir) throws IOException {
        block31: {
            JarEntry tempent;
            if (zipf == null) {
                throw new IllegalArgumentException("Cannot extract zip file, that is null.");
            }
            if (entryName == null) {
                throw new IllegalArgumentException("Cannot extract zip entry, that is null.");
            }
            if (dir == null) {
                throw new IllegalArgumentException("Cannot extract zip file to directory, that is null.");
            }
            String fName = entryName;
            fName = fName.replace('/', File.separatorChar);
            File f = new File(dir, fName = fName.replace('\\', File.separatorChar));
            if (f.isDirectory()) {
                return;
            }
            File parent = f.getParentFile();
            parent.mkdirs();
            JarEntry entry = (JarEntry)zipf.getEntry(entryName);
            if (entry == null) {
                entry = (JarEntry)zipf.getEntry(entryName.replace('\\', '/'));
            }
            if (entry == null) {
                entry = (JarEntry)zipf.getEntry(entryName.replace('/', '\\'));
            }
            if ((tempent = new JarEntry(entry)) == null || tempent.isDirectory()) {
                return;
            }
            BufferedInputStream in = new BufferedInputStream(zipf.getInputStream(tempent));
            FileOutputStream fos = new FileOutputStream(f);
            int count = 1024;
            byte[] buff = new byte[count];
            try {
                try {
                    while (count == 1024) {
                        count = ((InputStream)in).read(buff);
                        if (count <= 0) continue;
                        fos.write(buff, 0, count);
                    }
                }
                catch (EOFException eOFException) {
                    buff = new byte[(int)tempent.getSize()];
                    ((InputStream)in).read(buff);
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception exception) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

