/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal.blueprint;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.virgo.nano.core.internal.blueprint.Ticker;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;

public final class StandardTicker<V>
implements Ticker,
Callable<V> {
    private static final long OVERDUE = -1L;
    private final long creationTimeMillis;
    private long lastTickMillis;
    private final Ticker.HeartBeatPolicy heartBeatPolicy;
    private long heartBeatIntervalMillis;
    private boolean tickedAtLeastOnce;
    private boolean cancelled;
    private ScheduledFuture<V> scheduledFuture;
    private final Callable<V> action;
    private final ScheduledExecutorService scheduledExecutorService;
    private Object monitor;

    public static <V> Ticker createTicker(Ticker.HeartBeatPolicy heartBeatPolicy, Callable<V> action, ScheduledExecutorService scheduledExecutorService) {
        try {
            StandardTicker<V> ticker = new StandardTicker<V>(heartBeatPolicy, action, scheduledExecutorService);
            super.start();
            return ticker;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static <V> Ticker createExponentialTicker(long initialHeartbeatIntervalMillis, long heartBeatIncreasePercentage, long maxHeartBeatIntervalMillis, Callable<V> action, ScheduledExecutorService scheduledExecutorService) {
        try {
            return StandardTicker.createTicker(new ExponentialHeartBeatPolicy(initialHeartbeatIntervalMillis, heartBeatIncreasePercentage, maxHeartBeatIntervalMillis), action, scheduledExecutorService);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private StandardTicker(Ticker.HeartBeatPolicy heartBeatPolicy, Callable<V> action, ScheduledExecutorService scheduledExecutorService) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.tickedAtLeastOnce = false;
            this.cancelled = false;
            this.monitor = new Object();
            this.heartBeatPolicy = heartBeatPolicy;
            this.heartBeatIntervalMillis = this.heartBeatPolicy.getNextHeartBeatIntervalMillis();
            this.lastTickMillis = this.creationTimeMillis = System.currentTimeMillis();
            this.action = action;
            this.scheduledExecutorService = scheduledExecutorService;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void start() {
        try {
            if (this.getIntervalToNextTickMillis() == -1L) {
                try {
                    this.call();
                }
                catch (Exception exception) {}
            } else {
                this.scheduleNextTick();
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextTick() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.cancelled) {
                    this.scheduledFuture = this.scheduledExecutorService.schedule(this, this.getIntervalToNextTickMillis(), TimeUnit.MILLISECONDS);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public V call() throws Exception {
        try {
            boolean ticked = this.tick();
            this.scheduleNextTick();
            return ticked ? (V)this.action.call() : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.cancelled = true;
                this.scheduledFuture.cancel(true);
                return this.tickedAtLeastOnce;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tick() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                boolean ticked = false;
                if (!this.cancelled && this.getIntervalToNextTickMillis() == -1L) {
                    ticked = true;
                    this.lastTickMillis = this.getCurrentTimeMillis();
                    this.heartBeatIntervalMillis = this.heartBeatPolicy.getNextHeartBeatIntervalMillis();
                }
                this.tickedAtLeastOnce = this.tickedAtLeastOnce || ticked;
                return ticked;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private long getCurrentTimeMillis() {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTickMillis) {
                throw new IllegalArgumentException("Time must not go backwards");
            }
            return currentTimeMillis;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIntervalToNextTickMillis() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                long intervalSinceLastTickMillis = this.getCurrentTimeMillis() - this.lastTickMillis;
                return intervalSinceLastTickMillis < this.heartBeatIntervalMillis ? this.heartBeatIntervalMillis - intervalSinceLastTickMillis : -1L;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final class ExponentialHeartBeatPolicy
    implements Ticker.HeartBeatPolicy {
        private final long maxHeartBeatIntervalMillis;
        private final long heartBeatIncreasePercentage;
        private AtomicLong heartBeatIntervalMillis;

        public ExponentialHeartBeatPolicy(long initialHeartbeatIntervalMillis, long heartBeatIncreasePercentage, long maxHeartBeatIntervalMillis) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.heartBeatIntervalMillis = new AtomicLong(initialHeartbeatIntervalMillis);
                this.heartBeatIncreasePercentage = heartBeatIncreasePercentage;
                this.maxHeartBeatIntervalMillis = maxHeartBeatIntervalMillis;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public long getNextHeartBeatIntervalMillis() {
            try {
                boolean success = false;
                long nextHeartBeatIntervalMillis = 0L;
                while (!success) {
                    nextHeartBeatIntervalMillis = this.heartBeatIntervalMillis.get();
                    if (nextHeartBeatIntervalMillis < this.maxHeartBeatIntervalMillis) {
                        long newHeartBeatIntervalMillis = Math.min(nextHeartBeatIntervalMillis * (100L + this.heartBeatIncreasePercentage) / 100L, this.maxHeartBeatIntervalMillis);
                        success = this.heartBeatIntervalMillis.compareAndSet(nextHeartBeatIntervalMillis, newHeartBeatIntervalMillis);
                        continue;
                    }
                    success = true;
                }
                return nextHeartBeatIntervalMillis;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

