/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.ArtifactRepositoryListener;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotifyingRuntimeArtifactRepository
implements RuntimeArtifactRepository {
    private final Logger logger;
    private final Object monitor;
    private final Set<Artifact> artifacts;
    private final List<ArtifactRepositoryListener> listeners;

    public NotifyingRuntimeArtifactRepository(ArtifactRepositoryListener ... listeners) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.monitor = new Object();
            this.artifacts = new HashSet<Artifact>();
            this.listeners = Arrays.asList(listeners);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NonNull Artifact artifact) {
        Artifact artifact2 = artifact;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifact2);
            Object object = this.monitor;
            synchronized (object) {
                boolean result = this.artifacts.add(artifact);
                if (result) {
                    for (ArtifactRepositoryListener listener : this.listeners) {
                        try {
                            listener.added(artifact);
                        }
                        catch (Exception e) {
                            this.logger.error(String.format("Exception calling added() on listener '%s'", listener.toString()), (Throwable)e);
                        }
                    }
                }
                return result;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NonNull Artifact artifact) {
        Artifact artifact2 = artifact;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifact2);
            Object object = this.monitor;
            synchronized (object) {
                boolean result = this.artifacts.remove(artifact);
                if (result) {
                    for (ArtifactRepositoryListener listener : this.listeners) {
                        try {
                            listener.removed(artifact);
                        }
                        catch (Exception e) {
                            this.logger.error(String.format("Exception calling removed() on listener '%s'", listener.toString()), (Throwable)e);
                        }
                    }
                }
                return result;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NonNull String type, @NonNull String name, @NonNull Version version, @NonNull Region region) {
        Region region2 = region;
        Version version2 = version;
        String string = name;
        String string2 = type;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)string2);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)string);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)version2);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region2);
            Object object = this.monitor;
            synchronized (object) {
                Artifact artifact = this.getArtifact(type, name, version, region);
                if (artifact != null) {
                    return this.remove(artifact);
                }
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Artifact> getArtifacts() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return new HashSet<Artifact>(this.artifacts);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Artifact getArtifact(@NonNull String type, @NonNull String name, @NonNull Version version, @NonNull Region region) {
        Region region2 = region;
        Version version2 = version;
        String string = name;
        String string2 = type;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)string2);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)string);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)version2);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region2);
            Object object = this.monitor;
            synchronized (object) {
                for (Artifact artifact : this.artifacts) {
                    if (!artifact.getType().equals(type) || !artifact.getName().equals(name) || !artifact.getVersion().equals((Object)version) || !artifact.getRegion().getName().equals(region.getName())) continue;
                    return artifact;
                }
                return null;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

