/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.File;
import org.eclipse.virgo.nano.deployer.api.core.DeployerConfiguration;
import org.eclipse.virgo.util.io.PathReference;

final class StandardDeployerConfiguration
implements DeployerConfiguration {
    private final int deploymentTimeoutSeconds;
    private final PathReference deploymentPickupDirectory;
    private final int scanIntervalMillis;

    StandardDeployerConfiguration(int deploymentTimeout, File pickupDirectory, int scanIntervalMillis) {
        this.deploymentTimeoutSeconds = deploymentTimeout;
        this.deploymentPickupDirectory = new PathReference(pickupDirectory);
        this.scanIntervalMillis = scanIntervalMillis;
    }

    public int getDeploymentTimeoutSeconds() {
        return this.deploymentTimeoutSeconds;
    }

    public PathReference getDeploymentPickupDirectory() {
        return this.deploymentPickupDirectory;
    }

    public int getScanIntervalMillis() {
        return this.scanIntervalMillis;
    }

    public String toString() {
        return String.format("Timeout: '%s', Pickup directory: '%s', Scan interval in millis: '%s'", this.deploymentTimeoutSeconds, this.deploymentPickupDirectory, this.scanIntervalMillis);
    }
}

