/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.dmfragment.internal;

import org.eclipse.virgo.kernel.dmfragment.internal.ApplicationContextShutdownBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

class ServiceProxyRetryDisablingBundleListener
implements SynchronousBundleListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    ServiceProxyRetryDisablingBundleListener(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == 0L && event.getType() == 256) {
            BundleContext bundleContext = event.getBundle().getBundleContext();
            try {
                ServiceReference[] applicationContextServiceReferences;
                ServiceReference[] serviceReferenceArray = applicationContextServiceReferences = event.getBundle().getBundleContext().getAllServiceReferences(ApplicationContext.class.getName(), null);
                int n = applicationContextServiceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference applicationContextServiceReference = serviceReferenceArray[n2];
                    Object service = bundleContext.getService(applicationContextServiceReference);
                    if (service instanceof ApplicationContext) {
                        ApplicationContext applicationContext = (ApplicationContext)service;
                        ApplicationContextShutdownBean.disableServiceProxyRetry(applicationContext);
                        bundleContext.ungetService(applicationContextServiceReference);
                    }
                    ++n2;
                }
            }
            catch (InvalidSyntaxException ise) {
                this.logger.error("Failed to retrieve all application contexts from service registry", (Throwable)ise);
            }
        }
    }
}

