/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing.cache.artifact;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.PathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloader.class);
    private final URI repositoryArtifactURI;
    private final PathReference artifactCacheFilePathReference;

    Downloader(URI sourceUri, PathReference destination) {
        this.repositoryArtifactURI = sourceUri;
        this.artifactCacheFilePathReference = destination;
    }

    void downloadArtifact() {
        block14: {
            boolean downloadSuccessful = false;
            try {
                InputStream artifactInputStream = this.getArtifactInputStream();
                OutputStream artifactCacheOutputStream = this.getArtifactCacheOutputStream();
                if (artifactInputStream != null && artifactCacheOutputStream != null) {
                    try {
                        FileCopyUtils.copy((InputStream)artifactInputStream, (OutputStream)artifactCacheOutputStream);
                        downloadSuccessful = true;
                        break block14;
                    }
                    catch (IOException e) {
                        LOGGER.error("Error downloading artifact", (Throwable)e);
                        throw new RuntimeException("Error downloading artifact '" + this.repositoryArtifactURI + "'", e);
                    }
                }
                if (artifactInputStream != null) {
                    try {
                        artifactInputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error closing artifactInputStream", (Throwable)e);
                    }
                } else if (artifactCacheOutputStream != null) {
                    try {
                        artifactCacheOutputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error closing artifactCacheOutputStream", (Throwable)e);
                    }
                }
            }
            finally {
                if (!downloadSuccessful) {
                    LOGGER.warn("Artifact download failed. Cleaning up target file {}.", (Object)this.artifactCacheFilePathReference.toAbsoluteReference());
                    this.artifactCacheFilePathReference.delete();
                }
            }
        }
    }

    private InputStream getArtifactInputStream() {
        try {
            URL url = this.repositoryArtifactURI.toURL();
            URLConnection urlConnection = url.openConnection();
            return urlConnection.getInputStream();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Error accessing repository artifact", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error accessing repository artifact", (Throwable)e);
        }
        return null;
    }

    private OutputStream getArtifactCacheOutputStream() {
        try {
            this.artifactCacheFilePathReference.delete();
            return new FileOutputStream(this.artifactCacheFilePathReference.toFile());
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Error accessing repository artifact download destination file", (Throwable)e);
            return null;
        }
    }
}

