/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.deployer;

import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ConfigInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.SpringContextAccessor;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerBundleArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerCompositeArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerConfigArtifact;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private static final String USER_REGION_NAME = "org.eclipse.virgo.region.user";
    private final Logger logger;
    private final RuntimeArtifactRepository artifactRepository;
    private final BundleContext bundleContext;
    private final RegionDigraph regionDigraph;
    private final Region globalRegion;
    private final SpringContextAccessor springContextAccessor;

    public ModelInstallArtifactLifecycleListener(@NonNull BundleContext bundleContext, @NonNull RuntimeArtifactRepository artifactRepository, @NonNull RegionDigraph regionDigraph, @NonNull Region globalRegion, @NonNull SpringContextAccessor springContextAccessor) {
        SpringContextAccessor springContextAccessor2 = springContextAccessor;
        Region region = globalRegion;
        RegionDigraph regionDigraph2 = regionDigraph;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)regionDigraph2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)springContextAccessor2);
        try {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            this.bundleContext = bundleContext;
            this.artifactRepository = artifactRepository;
            this.regionDigraph = regionDigraph;
            this.springContextAccessor = springContextAccessor;
            this.globalRegion = globalRegion;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onInstalling(InstallArtifact installArtifact) throws DeploymentException {
        try {
            this.logEvent("installing", installArtifact);
            if (installArtifact instanceof PlanInstallArtifact) {
                this.addPlan((PlanInstallArtifact)installArtifact);
            } else if (installArtifact instanceof BundleInstallArtifact) {
                this.addOrReplaceBundle((BundleInstallArtifact)installArtifact);
            } else if (installArtifact instanceof ConfigInstallArtifact) {
                this.addConfiguration((ConfigInstallArtifact)installArtifact);
            } else {
                this.addArtifact(installArtifact);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addConfiguration(ConfigInstallArtifact configInstallArtifact) {
        try {
            this.artifactRepository.add(new DeployerConfigArtifact(this.bundleContext, configInstallArtifact, this.globalRegion));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addPlan(PlanInstallArtifact planInstallArtifact) {
        try {
            this.artifactRepository.add(new DeployerCompositeArtifact(this.bundleContext, planInstallArtifact, this.globalRegion));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addOrReplaceBundle(BundleInstallArtifact bundleInstallArtifact) {
        try {
            Artifact existingBundleArtifact = this.artifactRepository.getArtifact(bundleInstallArtifact.getType(), bundleInstallArtifact.getName(), bundleInstallArtifact.getVersion(), this.getRegion(USER_REGION_NAME));
            if (!(existingBundleArtifact instanceof DeployerBundleArtifact)) {
                this.remove((InstallArtifact)bundleInstallArtifact);
                this.artifactRepository.add(new DeployerBundleArtifact(this.bundleContext, bundleInstallArtifact, this.getRegion(USER_REGION_NAME), this.springContextAccessor));
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addArtifact(InstallArtifact installArtifact) {
        try {
            this.artifactRepository.add(new DeployerArtifact(this.bundleContext, installArtifact, this.globalRegion));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onInstallFailed(InstallArtifact installArtifact) throws DeploymentException {
        try {
            this.logEvent("install failed", installArtifact);
            this.remove(installArtifact);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        try {
            this.logEvent("uninstalled", installArtifact);
            this.remove(installArtifact);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void logEvent(String event, InstallArtifact installArtifact) {
        try {
            this.logger.info("Processing " + event + " event for {} '{}' version '{}'", new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString()});
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void remove(InstallArtifact installArtifact) {
        try {
            if (installArtifact instanceof BundleInstallArtifact) {
                this.artifactRepository.remove(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.getRegion(USER_REGION_NAME));
            } else {
                this.artifactRepository.remove(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.globalRegion);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Region getRegion(String name) {
        try {
            return this.regionDigraph.getRegion(name);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

