/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.NoHandlerFoundException;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.mvc.AbstractController;
import org.springframework.web.portlet.mvc.EventAwareController;
import org.springframework.web.portlet.mvc.ResourceAwareController;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletWrappingController
extends AbstractController
implements ResourceAwareController,
EventAwareController,
BeanNameAware,
InitializingBean,
DisposableBean,
PortletContextAware,
PortletConfigAware {
    private boolean useSharedPortletConfig = true;
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private Class<?> portletClass;
    private String portletName;
    private Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private String beanName;
    private Portlet portletInstance;

    public void setUseSharedPortletConfig(boolean useSharedPortletConfig) {
        this.useSharedPortletConfig = useSharedPortletConfig;
    }

    @Override
    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @Override
    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletClass(Class<?> portletClass) {
        this.portletClass = portletClass;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        PortletConfig config;
        if (this.portletClass == null) {
            throw new IllegalArgumentException("portletClass is required");
        }
        if (!Portlet.class.isAssignableFrom(this.portletClass)) {
            throw new IllegalArgumentException("portletClass [" + this.portletClass.getName() + "] needs to implement interface [javax.portlet.Portlet]");
        }
        if (this.portletName == null) {
            this.portletName = this.beanName;
        }
        if ((config = this.portletConfig) == null || !this.useSharedPortletConfig) {
            config = new DelegatingPortletConfig();
        }
        this.portletInstance = (Portlet)this.portletClass.newInstance();
        this.portletInstance.init(config);
    }

    @Override
    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        this.portletInstance.processAction(request, response);
    }

    @Override
    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        this.portletInstance.render(request, response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelAndView handleResourceRequest(ResourceRequest request, ResourceResponse response) throws Exception {
        PortletSession session;
        if (!(this.portletInstance instanceof ResourceServingPortlet)) {
            throw new NoHandlerFoundException("Cannot handle resource request - target portlet [" + this.portletInstance.getClass() + " does not implement ResourceServingPortlet");
        }
        ResourceServingPortlet resourcePortlet = (ResourceServingPortlet)this.portletInstance;
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        if (this.isSynchronizeOnSession() && (session = request.getPortletSession(false)) != null) {
            Object mutex;
            Object object = mutex = PortletUtils.getSessionMutex(session);
            synchronized (object) {
                resourcePortlet.serveResource(request, response);
                return null;
            }
        }
        resourcePortlet.serveResource(request, response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEventRequest(EventRequest request, EventResponse response) throws Exception {
        PortletSession session;
        if (!(this.portletInstance instanceof EventPortlet)) {
            this.logger.debug((Object)("Ignoring event request for non-event target portlet: " + this.portletInstance.getClass()));
            return;
        }
        EventPortlet eventPortlet = (EventPortlet)this.portletInstance;
        this.check((PortletRequest)request, (PortletResponse)response);
        if (this.isSynchronizeOnSession() && (session = request.getPortletSession(false)) != null) {
            Object mutex;
            Object object = mutex = PortletUtils.getSessionMutex(session);
            synchronized (object) {
                eventPortlet.processEvent(request, response);
                return;
            }
        }
        eventPortlet.processEvent(request, response);
    }

    public void destroy() {
        this.portletInstance.destroy();
    }

    private class DelegatingPortletConfig
    implements PortletConfig {
        private DelegatingPortletConfig() {
        }

        public String getPortletName() {
            return PortletWrappingController.this.portletName;
        }

        public PortletContext getPortletContext() {
            return PortletWrappingController.this.portletContext;
        }

        public String getInitParameter(String paramName) {
            return (String)PortletWrappingController.this.initParameters.get(paramName);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(PortletWrappingController.this.initParameters.keySet());
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return PortletWrappingController.this.portletConfig != null ? PortletWrappingController.this.portletConfig.getResourceBundle(locale) : null;
        }

        public Enumeration<String> getPublicRenderParameterNames() {
            return Collections.enumeration(Collections.emptySet());
        }

        public String getDefaultNamespace() {
            return "";
        }

        public Enumeration<QName> getPublishingEventQNames() {
            return Collections.enumeration(Collections.emptySet());
        }

        public Enumeration<QName> getProcessingEventQNames() {
            return Collections.enumeration(Collections.emptySet());
        }

        public Enumeration<Locale> getSupportedLocales() {
            return Collections.enumeration(Collections.emptySet());
        }

        public Map<String, String[]> getContainerRuntimeOptions() {
            return PortletWrappingController.this.portletConfig != null ? PortletWrappingController.this.portletConfig.getContainerRuntimeOptions() : null;
        }
    }
}

