/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.loader.SystemInstance;
import org.apache.webbeans.config.WebBeansContext;

public class OWBContextThreadListener
implements ThreadContextListener {
    ThreadSingletonService singletonService = (ThreadSingletonService)SystemInstance.get().getComponent(ThreadSingletonService.class);

    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        BeanContext beanContext = newContext.getBeanContext();
        if (beanContext == null) {
            return;
        }
        ModuleContext moduleContext = beanContext.getModuleContext();
        AppContext appContext = moduleContext.getAppContext();
        WebBeansContext owbContext = appContext.getWebBeansContext();
        if (owbContext == null) {
            return;
        }
        Object oldOWBContext = this.singletonService.contextEntered(owbContext);
        OWBContextHolder holder = new OWBContextHolder(oldOWBContext);
        newContext.set(OWBContextHolder.class, holder);
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        OWBContextHolder oldOWBContext = exitedContext.get(OWBContextHolder.class);
        if (oldOWBContext == null) {
            throw new NullPointerException("OWBContext not set in this thread");
        }
        this.singletonService.contextExited(oldOWBContext.getContext());
    }

    private static class OWBContextHolder {
        private final Object context;

        private OWBContextHolder(Object context) {
            this.context = context;
        }

        public Object getContext() {
            return this.context;
        }
    }
}

